/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap.utils.mapOver;

import com.remondis.remap.utils.propertywalker.BiRecursivePropertyWalker;
import com.remondis.remap.utils.propertywalker.PropertyAccess;
import com.remondis.remap.utils.propertywalker.VisitorFunction;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MapOver<R, T> {
    private MapOver<R, R> root;
    private BiRecursivePropertyWalker<T, T> walker;

    private MapOver(Class<T> beanType) {
        this.root = this;
        this.walker = BiRecursivePropertyWalker.create(beanType);
    }

    private MapOver(MapOver<R, R> root, BiRecursivePropertyWalker<T, T> walker) {
        this.root = root;
        this.walker = walker;
    }

    public <TT> MapOver<R, T> mapProperty(Function<T, TT> propertyExtractor, BiConsumer<T, TT> propertyWriter) {
        this.walker.addProperty(propertyExtractor, propertyWriter, this.propertyVisitor());
        return this;
    }

    public <TT> MapOver<R, T> addPropertyAction(Function<T, TT> propertyExtractor, BiConsumer<T, TT> propertyWriter, VisitorFunction<T, TT> action) {
        this.walker.addProperty(propertyExtractor, propertyWriter, action);
        return this;
    }

    public <TT> MapOver<R, TT> goInto(Function<T, TT> propertyExtractor, BiConsumer<T, TT> propertyWriter, Class<TT> beanType) {
        BiRecursivePropertyWalker<T, TT> goIntoWalker = this.walker.goInto(propertyExtractor, propertyWriter, beanType);
        return new MapOver<R, T>(this.root, goIntoWalker);
    }

    public static <R> MapOver<R, R> create(Class<R> beanType) {
        return new MapOver<R, R>(beanType);
    }

    private <TT> VisitorFunction<T, TT> propertyVisitor() {
        return new VisitorFunction<T, TT>(){

            @Override
            public void consume(PropertyAccess<T, TT> access) {
                Object sourceValue = access.sourceProperty().get();
                access.targetProperty().set(sourceValue);
            }
        };
    }

    public MapOver<R, R> build() {
        return this.root;
    }

    public void mapOver(T source, T target) {
        this.walker.execute(source, target);
    }
}

