/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.htmlparsing;

import com.renomad.minum.htmlparsing.ParseNodeType;
import com.renomad.minum.htmlparsing.TagInfo;
import com.renomad.minum.htmlparsing.TagName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HtmlParseNode {
    private final ParseNodeType type;
    private final TagInfo tagInfo;
    private final List<HtmlParseNode> innerContent;
    private final String textContent;
    public static final HtmlParseNode EMPTY = new HtmlParseNode(ParseNodeType.ELEMENT, TagInfo.EMPTY, List.of(), "EMPTY HTMLPARSENODE");

    public HtmlParseNode(ParseNodeType type, TagInfo tagInfo, List<HtmlParseNode> innerContent, String textContent) {
        this.type = type;
        this.tagInfo = tagInfo;
        this.innerContent = new ArrayList<HtmlParseNode>(innerContent);
        this.textContent = textContent;
    }

    public List<String> print() {
        ArrayList<String> myList = new ArrayList<String>();
        HtmlParseNode.recursiveTreeWalk(myList, this.innerContent, this.textContent);
        return myList;
    }

    static void recursiveTreeWalk(List<String> myList, List<HtmlParseNode> innerContent, String textContent) {
        for (HtmlParseNode hpn : innerContent) {
            HtmlParseNode.recursiveTreeWalk(myList, hpn.innerContent, hpn.textContent);
        }
        if (textContent != null && !textContent.isBlank()) {
            myList.add(textContent);
        }
    }

    public List<HtmlParseNode> search(TagName tagName, Map<String, String> attributes) {
        ArrayList<HtmlParseNode> myList = new ArrayList<HtmlParseNode>();
        this.recursiveTreeWalkSearch(myList, tagName, attributes);
        return myList;
    }

    private void recursiveTreeWalkSearch(List<HtmlParseNode> myList, TagName tagName, Map<String, String> attributes) {
        if (this.tagInfo.getTagName().equals((Object)tagName) && this.tagInfo.containsAllAttributes(attributes.entrySet())) {
            myList.add(this);
        }
        for (HtmlParseNode htmlParseNode : this.innerContent) {
            htmlParseNode.recursiveTreeWalkSearch(myList, tagName, attributes);
        }
    }

    static String innerText(List<HtmlParseNode> innerContent) {
        if (innerContent == null) {
            return "";
        }
        if (innerContent.size() == 1 && innerContent.getFirst().type == ParseNodeType.CHARACTERS) {
            return innerContent.getFirst().textContent;
        }
        StringBuilder sb = new StringBuilder();
        for (HtmlParseNode hpn : innerContent) {
            sb.append(hpn.print());
        }
        return sb.toString();
    }

    public ParseNodeType getType() {
        return this.type;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public List<HtmlParseNode> getInnerContent() {
        return new ArrayList<HtmlParseNode>(this.innerContent);
    }

    void addToInnerContent(HtmlParseNode htmlParseNode) {
        this.innerContent.add(htmlParseNode);
    }

    public String getTextContent() {
        return this.textContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HtmlParseNode)) {
            return false;
        }
        HtmlParseNode that = (HtmlParseNode)o;
        return this.type == that.type && Objects.equals(this.tagInfo, that.tagInfo) && Objects.equals(this.innerContent, that.innerContent) && Objects.equals(this.textContent, that.textContent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tagInfo, this.innerContent, this.textContent});
    }

    public String innerText() {
        return HtmlParseNode.innerText(this.innerContent);
    }
}

