/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.htmlparsing;

import com.renomad.minum.htmlparsing.HtmlParseNode;
import com.renomad.minum.htmlparsing.ParseNodeType;
import com.renomad.minum.htmlparsing.ParsingException;
import com.renomad.minum.htmlparsing.TagInfo;
import com.renomad.minum.htmlparsing.TagName;
import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.utils.RingBuffer;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class HtmlParser {
    static final int MAX_HTML_SIZE = 0x200000;
    static final List<Character> startOfComment = List.of(Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('-'), Character.valueOf('-'));
    static final List<Character> endOfComment = List.of(Character.valueOf('-'), Character.valueOf('-'), Character.valueOf('>'));
    static final List<Character> scriptElement = List.of(Character.valueOf('<'), Character.valueOf('/'), Character.valueOf('s'), Character.valueOf('c'), Character.valueOf('r'), Character.valueOf('i'), Character.valueOf('p'), Character.valueOf('t'), Character.valueOf('>'));

    public List<HtmlParseNode> parse(String input) {
        if (input.length() > 0x200000) {
            throw new ForbiddenUseException("Input exceeds max allowed HTML text size, 2097152 chars");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        ArrayList<HtmlParseNode> nodes = new ArrayList<HtmlParseNode>();
        State state = State.buildNewState();
        int value;
        while ((value = is.read()) != -1) {
            char currentChar = (char)value;
            this.processState(currentChar, state, nodes);
        }
        return nodes;
    }

    private void processState(char currentChar, State state, List<HtmlParseNode> nodes) {
        HtmlParser.recordLocation(currentChar, state);
        state.previousCharacters.add(Character.valueOf(currentChar));
        this.determineCommentState(state);
        this.determineScriptState(state);
        if (state.isInsideComment) {
            return;
        }
        if (state.isInsideScript) {
            state.stringBuilder.append(currentChar);
            return;
        }
        if (currentChar == '<') {
            this.processLessThan(currentChar, state);
        } else if (currentChar == '>') {
            this.processGreaterThan(currentChar, state, nodes);
        } else {
            this.addingToken(state, currentChar);
        }
    }

    private static void recordLocation(char currentChar, State state) {
        ++state.charsRead;
        if (currentChar == '\n') {
            ++state.lineRow;
            state.lineColumn = 0;
        }
        ++state.lineColumn;
    }

    private void processGreaterThan(char currentChar, State state, List<HtmlParseNode> nodes) {
        if (state.isInsideTag) {
            this.handleExitingTag(currentChar, state, nodes);
        } else {
            state.stringBuilder.append(currentChar);
        }
    }

    private void handleExitingTag(char currentChar, State state, List<HtmlParseNode> nodes) {
        if (state.isInsideAttributeValueQuoted) {
            state.stringBuilder.append(currentChar);
        } else {
            this.handleTagComponents(state, nodes);
        }
    }

    private void handleTagComponents(State state, List<HtmlParseNode> nodes) {
        if (HtmlParser.hasFinishedBuildingTagname(state.hasEncounteredTagName, state.tagName, state.stringBuilder)) {
            state.tagName = state.stringBuilder.toString();
        } else if (!state.stringBuilder.isEmpty() && state.currentAttributeKey.isBlank() && state.isReadingAttributeKey) {
            state.attributes.put(state.stringBuilder.toString(), "");
            state.stringBuilder = new StringBuilder();
            state.isReadingAttributeKey = false;
        } else if (!state.currentAttributeKey.isBlank()) {
            if (!state.stringBuilder.isEmpty()) {
                state.attributes.put(state.currentAttributeKey, state.stringBuilder.toString());
            } else {
                state.attributes.put(state.currentAttributeKey, "");
            }
            state.isInsideAttributeValueQuoted = false;
            state.stringBuilder = new StringBuilder();
            state.currentAttributeKey = "";
        }
        this.processTagAndResetState(state, nodes);
    }

    static boolean hasFinishedBuildingTagname(boolean hasEncounteredTagName, String tagName, StringBuilder sb) {
        return hasEncounteredTagName && tagName.isEmpty() && !sb.isEmpty();
    }

    private void processLessThan(char currentChar, State state) {
        if (state.isInsideAttributeValueQuoted) {
            state.stringBuilder.append(currentChar);
        } else {
            this.enteringTag(state);
        }
    }

    private void enteringTag(State state) {
        HtmlParser.addText(state);
        state.isInsideTag = true;
        state.isStartTag = true;
        state.stringBuilder = new StringBuilder();
    }

    private static void addText(State state) {
        if (!state.stringBuilder.isEmpty()) {
            String textContent = state.stringBuilder.toString();
            if (!state.parseStack.isEmpty() && !textContent.isBlank()) {
                state.parseStack.peek().addToInnerContent(new HtmlParseNode(ParseNodeType.CHARACTERS, TagInfo.EMPTY, new ArrayList<HtmlParseNode>(), textContent));
            }
        }
    }

    private void processTagAndResetState(State state, List<HtmlParseNode> nodes) {
        this.processTag(state, nodes);
        state.isHalfClosedTag = false;
        state.isInsideTag = false;
        state.isStartTag = false;
        state.isReadingTagName = false;
        state.tagName = "";
        state.attributes = new HashMap<String, String>();
        state.hasEncounteredTagName = false;
        state.stringBuilder = new StringBuilder();
    }

    private void addingToken(State state, char currentChar) {
        boolean hasNotBegunReadingTagName;
        boolean bl = hasNotBegunReadingTagName = state.isInsideTag && !state.hasEncounteredTagName;
        if (hasNotBegunReadingTagName) {
            HtmlParser.handleBeforeReadingTagName(state, currentChar);
        } else if (state.isReadingTagName) {
            HtmlParser.handleReadingTagName(state, currentChar);
        } else if (HtmlParser.isFinishedReadingTag(state.tagName, state.isInsideTag)) {
            HtmlParser.handleAfterReadingTagName(state, currentChar);
        } else {
            state.stringBuilder.append(currentChar);
        }
    }

    static boolean isFinishedReadingTag(String tagName, boolean isInsideTag) {
        return !tagName.isEmpty() && isInsideTag;
    }

    private void determineCommentState(State state) {
        boolean atCommentStart = state.previousCharacters.containsAt(startOfComment, 8);
        boolean atCommentEnd = state.previousCharacters.containsAt(endOfComment, 8);
        boolean isInsideTag = state.isInsideTag;
        boolean hasEncounteredTagName = state.hasEncounteredTagName;
        if (isInsideTag && !hasEncounteredTagName && atCommentStart) {
            state.isInsideComment = true;
            state.isInsideTag = false;
        } else if (state.isInsideComment && atCommentEnd) {
            state.isInsideComment = false;
        }
    }

    private void determineScriptState(State state) {
        boolean justClosedScriptTag;
        boolean isScriptFinished = state.previousCharacters.containsAt(scriptElement, 3);
        boolean wasInsideScript = state.isInsideScript;
        state.isInsideScript = state.isInsideScript && !isScriptFinished;
        boolean bl = justClosedScriptTag = wasInsideScript && !state.isInsideScript;
        if (justClosedScriptTag) {
            state.tagName = "script";
            state.isInsideTag = true;
            state.isStartTag = false;
            int innerTextLength = state.stringBuilder.length();
            state.stringBuilder.delete(innerTextLength - 8, innerTextLength);
            HtmlParser.addText(state);
        }
    }

    private static void handleAfterReadingTagName(State state, char currentChar) {
        boolean isHandlingAttributes = HtmlParser.isHandlingAttributes(state, currentChar);
        if (isHandlingAttributes) {
            if (state.currentAttributeKey.isBlank()) {
                HtmlParser.handleNotFullyReadAttributeKey(state, currentChar);
            } else {
                HtmlParser.handlePotentialAttributeValue(state, currentChar);
            }
        }
    }

    static boolean isHandlingAttributes(State state, char currentChar) {
        return !state.currentAttributeKey.isEmpty() || !state.stringBuilder.isEmpty() || currentChar != ' ';
    }

    private static void handlePotentialAttributeValue(State state, char currentChar) {
        if (state.isInsideAttributeValueQuoted) {
            if (currentChar == state.quoteType.literal) {
                state.isInsideAttributeValueQuoted = false;
                state.quoteType = QuoteType.NONE;
                state.attributes.put(state.currentAttributeKey, state.stringBuilder.toString());
                state.stringBuilder = new StringBuilder();
                state.currentAttributeKey = "";
                state.isReadingAttributeKey = false;
            } else {
                state.stringBuilder.append(currentChar);
            }
        } else if (currentChar == '\"' || currentChar == '\'') {
            state.isInsideAttributeValueQuoted = true;
            state.quoteType = QuoteType.byLiteral(currentChar);
        } else if (!state.stringBuilder.isEmpty() && currentChar == ' ') {
            state.attributes.put(state.currentAttributeKey, state.stringBuilder.toString());
            state.isReadingAttributeKey = false;
            state.stringBuilder = new StringBuilder();
            state.currentAttributeKey = "";
        } else {
            state.stringBuilder.append(currentChar);
        }
    }

    private static void handleNotFullyReadAttributeKey(State state, char currentChar) {
        if (state.isHalfClosedTag) {
            throw new ParsingException(String.format("in closing a void tag (e.g. <link />), character after forward slash must be angle bracket.  Char: %s at line %d and at the %d character. %d chars read in total.", Character.valueOf(currentChar), state.lineRow, state.lineColumn, state.charsRead));
        }
        if (currentChar == ' ' || currentChar == '=') {
            state.currentAttributeKey = state.stringBuilder.toString();
            state.isReadingAttributeKey = false;
            state.stringBuilder = new StringBuilder();
        } else if (currentChar == '/') {
            state.isReadingAttributeKey = false;
            state.isHalfClosedTag = true;
        } else {
            state.stringBuilder.append(currentChar);
            state.isReadingAttributeKey = true;
        }
    }

    private static void handleReadingTagName(State state, char currentChar) {
        if (Character.isWhitespace(currentChar)) {
            state.hasEncounteredTagName = true;
            state.isReadingTagName = false;
            state.tagName = state.stringBuilder.toString();
            state.attributes = new HashMap<String, String>();
            state.stringBuilder = new StringBuilder();
        } else {
            state.hasEncounteredTagName = true;
            state.tagName = "";
            state.stringBuilder.append(currentChar);
        }
    }

    private static void handleBeforeReadingTagName(State state, char currentChar) {
        if (currentChar == ' ') {
            state.stringBuilder = new StringBuilder();
        } else if (currentChar == '/') {
            state.isStartTag = false;
            state.stringBuilder = new StringBuilder();
        } else if (Character.isAlphabetic(currentChar)) {
            state.hasEncounteredTagName = true;
            state.isReadingTagName = true;
            state.stringBuilder.append(currentChar);
        }
    }

    private void processTag(State state, List<HtmlParseNode> nodes) {
        String tagNameString = state.tagName;
        TagName tagName = TagName.findMatchingTagname(tagNameString);
        if (tagName.equals((Object)TagName.UNRECOGNIZED)) {
            return;
        }
        TagInfo tagInfo = new TagInfo(tagName, state.attributes);
        if (state.isStartTag) {
            HtmlParseNode newNode = new HtmlParseNode(ParseNodeType.ELEMENT, tagInfo, new ArrayList<HtmlParseNode>(), "");
            if (!state.parseStack.isEmpty()) {
                state.parseStack.peek().addToInnerContent(newNode);
            }
            if (state.parseStack.isEmpty() && tagName.isVoidElement) {
                nodes.add(newNode);
            } else if (!tagName.isVoidElement) {
                state.parseStack.push(newNode);
            }
            if (tagName.equals((Object)TagName.SCRIPT)) {
                state.isInsideScript = true;
                state.stringBuilder = new StringBuilder();
            }
        } else {
            TagName expectedTagName;
            HtmlParseNode htmlParseNode;
            try {
                htmlParseNode = state.parseStack.pop();
            }
            catch (NoSuchElementException ex) {
                throw new ParsingException("No starting tag found. At line " + state.lineRow + " and at the " + state.lineColumn + "th character. " + state.charsRead + " characters read in total.");
            }
            if (state.parseStack.isEmpty()) {
                nodes.add(htmlParseNode);
            }
            if ((expectedTagName = htmlParseNode.getTagInfo().getTagName()) != tagName) {
                throw new ParsingException("Did not find expected closing-tag type. Expected: " + String.valueOf((Object)expectedTagName) + " at line " + state.lineRow + " and at the " + state.lineColumn + "th character. " + state.charsRead + " characters read in total.");
            }
        }
    }

    public List<HtmlParseNode> search(List<HtmlParseNode> nodes, TagName tagName, Map<String, String> attributes) {
        ArrayList<HtmlParseNode> foundNodes = new ArrayList<HtmlParseNode>();
        for (HtmlParseNode node : nodes) {
            List<HtmlParseNode> result = node.search(tagName, attributes);
            foundNodes.addAll(result);
        }
        return foundNodes;
    }

    static class State {
        boolean isHalfClosedTag;
        int charsRead;
        boolean isInsideTag;
        StringBuilder stringBuilder;
        final Deque<HtmlParseNode> parseStack;
        boolean hasEncounteredTagName;
        boolean isReadingTagName;
        boolean isReadingAttributeKey;
        boolean isStartTag;
        boolean isInsideAttributeValueQuoted;
        QuoteType quoteType;
        String tagName;
        String currentAttributeKey;
        Map<String, String> attributes;
        int lineRow;
        int lineColumn;
        final RingBuffer<Character> previousCharacters;
        boolean isInsideComment;
        boolean isInsideScript;

        static State buildNewState() {
            RingBuffer<Character> previousCharacters = new RingBuffer<Character>(12, Character.class);
            int lineColumn1 = 0;
            int lineRow1 = 1;
            boolean isHalfClosedTag1 = false;
            boolean isInsideAttributeValueQuoted1 = false;
            boolean isStartTag1 = true;
            boolean isReadingTagName1 = false;
            boolean hasEncounteredTagName1 = false;
            ArrayDeque<HtmlParseNode> parseStack1 = new ArrayDeque<HtmlParseNode>();
            StringBuilder stringBuilder1 = new StringBuilder();
            boolean isInsideTag1 = false;
            int charsRead1 = 0;
            String tagName1 = "";
            String currentAttributeKey1 = "";
            HashMap<String, String> attributes1 = new HashMap<String, String>();
            boolean isReadingAttributeKey1 = false;
            boolean isInsideComment1 = false;
            boolean isInsideScript1 = false;
            return new State(charsRead1, isInsideTag1, stringBuilder1, parseStack1, hasEncounteredTagName1, isReadingTagName1, isStartTag1, isInsideAttributeValueQuoted1, tagName1, currentAttributeKey1, attributes1, QuoteType.NONE, isReadingAttributeKey1, isHalfClosedTag1, lineRow1, lineColumn1, previousCharacters, isInsideComment1, isInsideScript1);
        }

        public State(int charsRead, boolean isInsideTag, StringBuilder stringBuilder, Deque<HtmlParseNode> parseStack, boolean hasEncounteredTagName, boolean isReadingTagName, boolean isStartTag, boolean isInsideAttributeValueQuoted, String tagName, String currentAttributeKey, Map<String, String> attributes, QuoteType quoteType, boolean isReadingAttributeKey, boolean isHalfClosedTag, int lineRow, int lineColumn, RingBuffer<Character> previousCharacters, boolean isInsideComment, boolean isInsideScript) {
            this.charsRead = charsRead;
            this.isInsideTag = isInsideTag;
            this.stringBuilder = stringBuilder;
            this.parseStack = parseStack;
            this.hasEncounteredTagName = hasEncounteredTagName;
            this.isReadingTagName = isReadingTagName;
            this.isStartTag = isStartTag;
            this.isInsideAttributeValueQuoted = isInsideAttributeValueQuoted;
            this.tagName = tagName;
            this.currentAttributeKey = currentAttributeKey;
            this.attributes = attributes;
            this.quoteType = quoteType;
            this.isReadingAttributeKey = isReadingAttributeKey;
            this.isHalfClosedTag = isHalfClosedTag;
            this.lineRow = lineRow;
            this.lineColumn = lineColumn;
            this.previousCharacters = previousCharacters;
            this.isInsideComment = isInsideComment;
            this.isInsideScript = isInsideScript;
        }
    }

    static enum QuoteType {
        SINGLE_QUOTED('\''),
        DOUBLE_QUOTED('\"'),
        NONE('\u0000');

        public final char literal;

        private QuoteType(char literal) {
            this.literal = literal;
        }

        public static QuoteType byLiteral(char currentChar) {
            if (currentChar == '\'') {
                return SINGLE_QUOTED;
            }
            return DOUBLE_QUOTED;
        }
    }
}

