/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.htmlparsing;

import com.renomad.minum.htmlparsing.TagName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class TagInfo {
    private final TagName tagName;
    private final Map<String, String> attributes;
    public static final TagInfo EMPTY = new TagInfo(TagName.NULL, Map.of());

    public TagInfo(TagName tagName, Map<String, String> attributes) {
        this.tagName = tagName;
        this.attributes = new HashMap<String, String>(attributes);
    }

    public TagName getTagName() {
        return this.tagName;
    }

    boolean containsAllAttributes(Set<Map.Entry<String, String>> entries) {
        return this.attributes.entrySet().containsAll(entries);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagInfo)) {
            return false;
        }
        TagInfo tagInfo = (TagInfo)o;
        return this.tagName == tagInfo.tagName && Objects.equals(this.attributes, tagInfo.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tagName, this.attributes});
    }

    public String toString() {
        return "TagInfo{tagName=" + String.valueOf((Object)this.tagName) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

