/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.logging;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.logging.LoggingActionQueue;
import com.renomad.minum.logging.LoggingLevel;
import com.renomad.minum.logging.ThrowingSupplier;
import com.renomad.minum.queue.AbstractActionQueue;
import com.renomad.minum.state.Constants;
import com.renomad.minum.utils.TimeUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class Logger
implements ILogger {
    protected final AbstractActionQueue loggingActionQueue;
    private final Constants constants;
    private final ExecutorService executorService;
    private final String name;
    private final Map<LoggingLevel, Boolean> activeLogLevels;

    public Logger(Constants constants, ExecutorService executorService, String name) {
        this(constants, executorService, name, null);
    }

    private Logger(Constants constants, ExecutorService executorService, String name, AbstractActionQueue loggingActionQueue) {
        this.constants = constants;
        this.executorService = executorService;
        this.name = name;
        this.loggingActionQueue = loggingActionQueue == null ? new LoggingActionQueue("loggerPrinter" + name, executorService, constants).initialize() : loggingActionQueue;
        this.activeLogLevels = Logger.convertToMap(constants.logLevels);
    }

    public Logger(Logger logger) {
        this(logger.constants, logger.executorService, logger.name, logger.loggingActionQueue);
    }

    static Map<LoggingLevel, Boolean> convertToMap(List<LoggingLevel> enabledLoggingLevels) {
        EnumMap<LoggingLevel, Boolean> activeLogLevels = new EnumMap<LoggingLevel, Boolean>(LoggingLevel.class);
        for (LoggingLevel t : LoggingLevel.values()) {
            activeLogLevels.put(t, enabledLoggingLevels.contains((Object)t));
        }
        return activeLogLevels;
    }

    @Override
    public void logDebug(ThrowingSupplier<String, Exception> msg) {
        Logger.logHelper(msg, LoggingLevel.DEBUG, this.activeLogLevels, this.loggingActionQueue);
    }

    @Override
    public void logTrace(ThrowingSupplier<String, Exception> msg) {
        Logger.logHelper(msg, LoggingLevel.TRACE, this.activeLogLevels, this.loggingActionQueue);
    }

    @Override
    public void logAudit(ThrowingSupplier<String, Exception> msg) {
        Logger.logHelper(msg, LoggingLevel.AUDIT, this.activeLogLevels, this.loggingActionQueue);
    }

    @Override
    public void stop() {
        this.loggingActionQueue.stop();
        this.executorService.shutdownNow();
    }

    @Override
    public void logAsyncError(ThrowingSupplier<String, Exception> msg) {
        Logger.logHelper(msg, LoggingLevel.ASYNC_ERROR, this.activeLogLevels, this.loggingActionQueue);
    }

    @Override
    public Map<LoggingLevel, Boolean> getActiveLogLevels() {
        return this.activeLogLevels;
    }

    static void logHelper(ThrowingSupplier<String, Exception> msg, LoggingLevel loggingLevel, Map<LoggingLevel, Boolean> activeLogLevels, AbstractActionQueue loggingActionQueue) {
        if (Boolean.TRUE.equals(activeLogLevels.get((Object)loggingLevel))) {
            Object receivedMessage;
            try {
                receivedMessage = msg.get();
            }
            catch (Exception ex) {
                receivedMessage = "EXCEPTION DURING GET: " + String.valueOf(ex);
            }
            String finalReceivedMessage = receivedMessage;
            if (loggingActionQueue == null || loggingActionQueue.isStopped()) {
                Object[] args = new Object[]{TimeUtils.getTimestampIsoInstant(), loggingLevel.name(), Logger.showWhiteSpace(finalReceivedMessage)};
                System.out.printf("%s\t%s\t%s%n", args);
            } else {
                loggingActionQueue.enqueue("Logger#logHelper(" + (String)receivedMessage + ")", () -> {
                    Object[] args = new Object[]{TimeUtils.getTimestampIsoInstant(), loggingLevel.name(), Logger.showWhiteSpace(finalReceivedMessage)};
                    System.out.printf("%s\t%s\t%s%n", args);
                });
            }
        }
    }

    static String showWhiteSpace(String msg) {
        if (msg == null) {
            return "(NULL)";
        }
        if (msg.isEmpty()) {
            return "(EMPTY)";
        }
        String text = msg.replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n");
        if (text.isBlank()) {
            return "(BLANK)";
        }
        return text;
    }
}

