/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.logging;

import com.renomad.minum.logging.Logger;
import com.renomad.minum.logging.LoggingLevel;
import com.renomad.minum.queue.AbstractActionQueue;
import com.renomad.minum.state.Constants;
import com.renomad.minum.utils.MyThread;
import com.renomad.minum.utils.RunnableWithDescription;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.utils.TimeUtils;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

final class LoggingActionQueue
implements AbstractActionQueue {
    private final String name;
    private final ExecutorService executorService;
    private final LinkedBlockingQueue<RunnableWithDescription> queue;
    private Thread queueThread;
    private boolean stop = false;
    private boolean isStoppedStatus = false;
    private final Map<LoggingLevel, Boolean> enabledLogLevels;

    LoggingActionQueue(String name, ExecutorService executorService, Constants constants) {
        this.name = name;
        this.executorService = executorService;
        this.queue = new LinkedBlockingQueue();
        this.enabledLogLevels = Logger.convertToMap(constants.logLevels);
    }

    @Override
    public AbstractActionQueue initialize() {
        Runnable centralLoop = () -> {
            Thread.currentThread().setName(this.name);
            this.queueThread = Thread.currentThread();
            try {
                while (true) {
                    LoggingActionQueue.runAction(this.queue.take());
                }
            }
            catch (InterruptedException ex) {
                Logger.logHelper(() -> String.format("%s LoggingActionQueue for %s is stopped.%n", TimeUtils.getTimestampIsoInstant(), this.name), LoggingLevel.DEBUG, this.enabledLogLevels, this);
                Thread.currentThread().interrupt();
                return;
            }
        };
        this.executorService.submit(centralLoop);
        return this;
    }

    static void runAction(RunnableWithDescription action) {
        action.run();
    }

    @Override
    public void enqueue(String description, ThrowingRunnable action) {
        if (!this.stop) {
            this.queue.add(new RunnableWithDescription(action, description));
        }
    }

    @Override
    public void stop(int count, int sleepTime) {
        Logger.logHelper(() -> String.format("%s Stopping queue %s%n", TimeUtils.getTimestampIsoInstant(), this), LoggingLevel.DEBUG, this.enabledLogLevels, this);
        this.stop = true;
        for (int i = 0; i < count; ++i) {
            if (this.queue.isEmpty()) {
                return;
            }
            Logger.logHelper(() -> String.format("%s Queue not yet empty, has %d elements. waiting...%n", TimeUtils.getTimestampIsoInstant(), this.queue.size()), LoggingLevel.DEBUG, this.enabledLogLevels, this);
            MyThread.sleep(sleepTime);
        }
        this.isStoppedStatus = true;
        Logger.logHelper(() -> String.format("%s Queue %s has %d elements left but we're done waiting.  Queue toString: %s", TimeUtils.getTimestampIsoInstant(), this, this.queue.size(), this.queue), LoggingLevel.DEBUG, this.enabledLogLevels, this);
    }

    @Override
    public void stop() {
        this.stop(5, 20);
    }

    public Thread getQueueThread() {
        return this.queueThread;
    }

    @Override
    public LinkedBlockingQueue<RunnableWithDescription> getQueue() {
        return this.queue;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isStopped() {
        return this.isStoppedStatus;
    }
}

