/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.logging;

import com.renomad.minum.logging.Logger;
import com.renomad.minum.logging.TestLoggerException;
import com.renomad.minum.logging.TestLoggerQueue;
import com.renomad.minum.logging.ThrowingSupplier;
import com.renomad.minum.state.Constants;
import com.renomad.minum.utils.MyThread;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public final class TestLogger
extends Logger {
    private final Queue<String> recentLogLines = new TestLoggerQueue(30);
    public static final int MAX_CACHE_SIZE = 30;
    private final ReentrantLock loggingLock = new ReentrantLock();
    private int testCount = 0;

    public TestLogger(Constants constants, ExecutorService executorService, String name) {
        super(constants, executorService, name);
    }

    private String extractMessage(ThrowingSupplier<String, Exception> msg) {
        Object receivedMessage;
        try {
            receivedMessage = msg.get();
        }
        catch (Exception ex) {
            receivedMessage = "EXCEPTION DURING GET: " + String.valueOf(ex);
        }
        return receivedMessage;
    }

    private void addToCache(ThrowingSupplier<String, Exception> msg) {
        String message = this.extractMessage(msg);
        String safeMessage = message == null ? "(null message)" : message;
        this.recentLogLines.add(safeMessage);
    }

    @Override
    public void logDebug(ThrowingSupplier<String, Exception> msg) {
        this.loggingLock.lock();
        try {
            this.addToCache(msg);
            super.logDebug(msg);
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    @Override
    public void logTrace(ThrowingSupplier<String, Exception> msg) {
        this.loggingLock.lock();
        try {
            this.addToCache(msg);
            super.logTrace(msg);
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    @Override
    public void logAudit(ThrowingSupplier<String, Exception> msg) {
        this.loggingLock.lock();
        try {
            this.addToCache(msg);
            super.logAudit(msg);
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    @Override
    public void logAsyncError(ThrowingSupplier<String, Exception> msg) {
        this.loggingLock.lock();
        try {
            this.addToCache(msg);
            super.logAsyncError(msg);
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    public String findFirstMessageThatContains(String value, int lines) {
        List<String> values = TestLogger.findMessage(value, lines, this.recentLogLines);
        List<String> logsBeingSearched = TestLogger.logLinesToSearch(lines, this.recentLogLines);
        return TestLogger.checkValidityOfResults(value, values, logsBeingSearched);
    }

    static String checkValidityOfResults(String value, List<String> values, List<String> recentLogLines) {
        int size = values.size();
        if (size == 0) {
            throw new TestLoggerException(value + " was not found in \n\t" + String.join((CharSequence)"\n\t", recentLogLines));
        }
        if (size >= 2) {
            throw new TestLoggerException("multiple values of " + value + " found in: " + String.valueOf(recentLogLines));
        }
        return values.getFirst();
    }

    public boolean doesMessageExist(String value, int lines) {
        if (!TestLogger.findMessage(value, lines, this.recentLogLines).isEmpty()) {
            return true;
        }
        List<String> logsBeingSearched = TestLogger.logLinesToSearch(lines, this.recentLogLines);
        throw new TestLoggerException(value + " was not found in \n\t" + String.join((CharSequence)"\n\t", logsBeingSearched));
    }

    public boolean doesMessageExist(String value) {
        return this.doesMessageExist(value, 3);
    }

    static List<String> findMessage(String value, int lines, Queue<String> recentLogLines) {
        if (lines > 30) {
            throw new TestLoggerException(String.format("Can only get up to %s lines from the log", 30));
        }
        if (lines <= 0) {
            throw new TestLoggerException("number of recent log lines must be a positive number");
        }
        MyThread.sleep(20L);
        List<String> lineList = TestLogger.logLinesToSearch(lines, recentLogLines);
        return lineList.stream().filter(x -> x.toLowerCase(Locale.ROOT).contains(value.toLowerCase(Locale.ROOT))).toList();
    }

    private static List<String> logLinesToSearch(int lines, Queue<String> recentLogLines) {
        int fromIndex = Math.max(recentLogLines.size() - lines, 0);
        return recentLogLines.stream().toList().subList(fromIndex, recentLogLines.size());
    }

    public String findFirstMessageThatContains(String value) {
        return this.findFirstMessageThatContains(value, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(String msg) {
        this.loggingLock.lock();
        try {
            int baseLength = 11;
            String dashes = "-".repeat(msg.length() + 11);
            this.loggingActionQueue.enqueue("Testlogger#test(" + msg + ")", () -> {
                ++this.testCount;
                System.out.printf("%n+%s+%n| TEST %d: %s |%n+%s+%n%n", dashes, this.testCount, msg, dashes);
                this.recentLogLines.add(msg);
            });
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public String toString() {
        return "TestLogger using queue: " + this.loggingActionQueue.toString();
    }
}

