/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.queue;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.queue.AbstractActionQueue;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.MyThread;
import com.renomad.minum.utils.RunnableWithDescription;
import com.renomad.minum.utils.StacktraceUtils;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.utils.TimeUtils;
import com.renomad.minum.utils.UtilsException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

public final class ActionQueue
implements AbstractActionQueue {
    private final String name;
    private final ExecutorService queueExecutor;
    private final LinkedBlockingQueue<RunnableWithDescription> queue;
    private final ILogger logger;
    private boolean stop = false;
    private Thread queueThread;
    private boolean isStoppedStatus;

    public ActionQueue(String name, Context context) {
        this.name = name;
        this.queueExecutor = context.getExecutorService();
        this.queue = new LinkedBlockingQueue();
        context.getActionQueueState().offerToQueue(this);
        this.logger = context.getLogger();
    }

    @Override
    public ActionQueue initialize() {
        Runnable centralLoop = () -> {
            Thread.currentThread().setName(this.name);
            this.queueThread = Thread.currentThread();
            try {
                while (true) {
                    this.runAction();
                }
            }
            catch (InterruptedException ex) {
                this.logger.logDebug(() -> String.format("%s ActionQueue for %s is stopped.%n", TimeUtils.getTimestampIsoInstant(), this.name));
                Thread.currentThread().interrupt();
                return;
            }
        };
        this.queueExecutor.submit(centralLoop);
        return this;
    }

    private void runAction() throws InterruptedException {
        RunnableWithDescription action = this.queue.take();
        try {
            action.run();
        }
        catch (Exception e) {
            this.logger.logAsyncError(() -> StacktraceUtils.stackTraceToString(e));
        }
    }

    @Override
    public void enqueue(String description, ThrowingRunnable action) {
        if (this.stop) {
            throw new UtilsException(String.format("failed to enqueue %s - ActionQueue \"%s\" is stopped", description, this.name));
        }
        this.queue.add(new RunnableWithDescription(action, description));
    }

    @Override
    public void stop(int count, int sleepTime) {
        String timestamp = TimeUtils.getTimestampIsoInstant();
        this.logger.logDebug(() -> String.format("%s Stopping queue %s", timestamp, this));
        this.stop = true;
        for (int i = 0; i < count; ++i) {
            if (this.queue.isEmpty()) {
                return;
            }
            this.logger.logDebug(() -> String.format("%s Queue not yet empty, has %d elements. waiting...%n", timestamp, this.queue.size()));
            MyThread.sleep(sleepTime);
        }
        this.isStoppedStatus = true;
        this.logger.logDebug(() -> String.format("%s Queue %s has %d elements left but we're done waiting.  Queue toString: %s", timestamp, this, this.queue.size(), this.queue));
    }

    @Override
    public void stop() {
        this.stop(5, 20);
    }

    public String toString() {
        return this.name;
    }

    Thread getQueueThread() {
        return this.queueThread;
    }

    @Override
    public LinkedBlockingQueue<RunnableWithDescription> getQueue() {
        return new LinkedBlockingQueue<RunnableWithDescription>(this.queue);
    }

    @Override
    public boolean isStopped() {
        return this.isStoppedStatus;
    }
}

