/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.queue;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.queue.AbstractActionQueue;
import com.renomad.minum.queue.ActionQueue;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.TimeUtils;

public final class ActionQueueKiller {
    private final Context context;
    private final ILogger logger;
    private boolean hadToInterrupt;

    public ActionQueueKiller(Context context) {
        this.context = context;
        this.logger = context.getLogger();
        this.hadToInterrupt = false;
    }

    public void killAllQueues() {
        this.logger.logDebug(() -> TimeUtils.getTimestampIsoInstant() + " Killing all queue threads. ");
        AbstractActionQueue aq = this.context.getActionQueueState().pollFromQueue();
        while (aq != null) {
            AbstractActionQueue finalAq = aq;
            finalAq.stop();
            this.logger.logDebug(() -> TimeUtils.getTimestampIsoInstant() + " killing " + String.valueOf(((ActionQueue)finalAq).getQueueThread()));
            if (((ActionQueue)finalAq).getQueueThread() != null) {
                this.hadToInterrupt = true;
                System.out.println("had to interrupt " + String.valueOf(finalAq));
                ((ActionQueue)finalAq).getQueueThread().interrupt();
            }
            aq = this.context.getActionQueueState().pollFromQueue();
        }
    }

    public boolean hadToInterrupt() {
        return this.hadToInterrupt;
    }
}

