/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.security;

import com.renomad.minum.database.DbData;
import com.renomad.minum.utils.SerializationUtils;
import java.util.List;
import java.util.Objects;

public final class Inmate
extends DbData<Inmate> {
    public static final Inmate EMPTY = new Inmate(0L, "", 0L);
    private Long index;
    private final String clientId;
    private final Long releaseTime;

    public Inmate(Long index, String clientId, Long releaseTime) {
        this.index = index;
        this.clientId = clientId;
        this.releaseTime = releaseTime;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    public String serialize() {
        return SerializationUtils.serializeHelper(this.index, this.clientId, this.releaseTime);
    }

    @Override
    public Inmate deserialize(String serializedText) {
        List<String> tokens = SerializationUtils.deserializeHelper(serializedText);
        return new Inmate(Long.parseLong(tokens.get(0)), tokens.get(1), Long.parseLong(tokens.get(2)));
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getReleaseTime() {
        return this.releaseTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inmate inmate = (Inmate)o;
        return Objects.equals(this.index, inmate.index) && Objects.equals(this.clientId, inmate.clientId) && Objects.equals(this.releaseTime, inmate.releaseTime);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.clientId, this.releaseTime);
    }

    public String toString() {
        return "Inmate{index=" + this.index + ", clientId='" + this.clientId + "', releaseTime=" + this.releaseTime + "}";
    }
}

