/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.security;

import com.renomad.minum.database.Db;
import com.renomad.minum.logging.ILogger;
import com.renomad.minum.security.ITheBrig;
import com.renomad.minum.security.Inmate;
import com.renomad.minum.security.MinumSecurityException;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.SearchUtils;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public final class TheBrig
implements ITheBrig {
    private final ExecutorService es;
    private final Db<Inmate> inmatesDb;
    private final ILogger logger;
    private final Constants constants;
    private final ReentrantLock lock = new ReentrantLock();
    private Thread myThread;
    private final int sleepTime;

    public TheBrig(int sleepTime, Context context) {
        this.es = context.getExecutorService();
        this.constants = context.getConstants();
        this.logger = context.getLogger();
        this.inmatesDb = context.getDb("the_brig", Inmate.EMPTY);
        this.sleepTime = sleepTime;
    }

    public TheBrig(Context context) {
        this(10000, context);
    }

    @Override
    public ITheBrig initialize() {
        this.logger.logDebug(() -> "Initializing TheBrig main loop");
        ThrowingRunnable innerLoopThread = () -> {
            Thread.currentThread().setName("TheBrigThread");
            this.myThread = Thread.currentThread();
            try {
                while (true) {
                    this.reviewCurrentInmates();
                }
            }
            catch (InterruptedException ex) {
                this.logger.logDebug(() -> String.format("%s TheBrig is stopped.%n", TimeUtils.getTimestampIsoInstant()));
                Thread.currentThread().interrupt();
                return;
            }
        };
        this.es.submit(ThrowingRunnable.throwingRunnableWrapper(innerLoopThread, this.logger));
        return this;
    }

    private void reviewCurrentInmates() throws InterruptedException {
        Collection<Inmate> values = this.inmatesDb.values();
        if (!values.isEmpty()) {
            this.logger.logTrace(() -> "TheBrig reviewing current inmates. Count: " + values.size());
        }
        long now = System.currentTimeMillis();
        TheBrig.processInmateList(now, values, this.logger, this.inmatesDb);
        Thread.sleep(this.sleepTime);
    }

    static void processInmateList(long now, Collection<Inmate> inmates, ILogger logger, Db<Inmate> inmatesDb) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Inmate clientKeyAndDuration : inmates) {
            TheBrig.reviewForParole(now, keysToRemove, clientKeyAndDuration, logger);
        }
        for (String k : keysToRemove) {
            logger.logTrace(() -> "TheBrig: removing " + k + " from jail");
            Inmate inmateToRemove = SearchUtils.findExactlyOne(inmates.stream(), x -> x.getClientId().equals(k));
            inmatesDb.delete(inmateToRemove);
        }
    }

    private static void reviewForParole(long now, List<String> keysToRemove, Inmate inmate, ILogger logger) {
        if (inmate.getReleaseTime() < now) {
            logger.logTrace(() -> "UnderInvestigation: " + inmate.getClientId() + " has paid its dues as of " + inmate.getReleaseTime() + " and is getting released. Current time: " + now);
            keysToRemove.add(inmate.getClientId());
        }
    }

    @Override
    public void stop() {
        this.logger.logDebug(() -> "TheBrig has been told to stop");
        if (this.myThread == null) {
            throw new MinumSecurityException("TheBrig was told to stop, but it was uninitialized");
        }
        this.logger.logDebug(() -> "TheBrig: Sending interrupt to thread");
        this.myThread.interrupt();
        this.inmatesDb.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendToJail(String clientIdentifier, long sentenceDuration) {
        if (!this.constants.isTheBrigEnabled) {
            return false;
        }
        this.lock.lock();
        try {
            long now = System.currentTimeMillis();
            Inmate existingInmate = SearchUtils.findExactlyOne(this.inmatesDb.values().stream(), x -> x.getClientId().equals(clientIdentifier));
            if (existingInmate == null) {
                long releaseTime = now + sentenceDuration;
                this.logger.logDebug(() -> "TheBrig: Putting away " + clientIdentifier + " for " + sentenceDuration + " milliseconds. Release time: " + releaseTime + ". Current time: " + now);
                Inmate newInmate = new Inmate(0L, clientIdentifier, releaseTime);
                this.inmatesDb.write(newInmate);
            } else {
                long releaseTime = existingInmate.getReleaseTime() + sentenceDuration;
                this.logger.logDebug(() -> "TheBrig: Putting away " + clientIdentifier + " for " + sentenceDuration + " milliseconds. Release time: " + releaseTime + ". Current time: " + now);
                this.inmatesDb.write(new Inmate(existingInmate.getIndex(), existingInmate.getClientId(), releaseTime));
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public boolean isInJail(String clientIdentifier) {
        if (!this.constants.isTheBrigEnabled) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.inmatesDb.values().stream().anyMatch(x -> x.getClientId().equals(clientIdentifier));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Inmate> getInmates() {
        this.lock.lock();
        try {
            List<Inmate> list = this.inmatesDb.values().stream().toList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }
}

