/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.state;

import com.renomad.minum.logging.LoggingLevel;
import com.renomad.minum.utils.TimeUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public final class Constants {
    private final Properties properties;
    public final int serverPort;
    public final int secureServerPort;
    public final String hostName;
    public final String dbDirectory;
    public final String staticFilesDirectory;
    public final List<LoggingLevel> logLevels;
    public final String keystorePath;
    public final String keystorePassword;
    public final int maxReadSizeBytes;
    public final int maxReadLineSizeBytes;
    public final int socketTimeoutMillis;
    public final int keepAliveTimeoutSeconds;
    public final int vulnSeekingJailDuration;
    public final boolean isTheBrigEnabled;
    public final List<String> suspiciousErrors;
    public final List<String> suspiciousPaths;
    public final long startTime;
    public final List<String> extraMimeMappings;
    public final long staticFileCacheTime;
    public final boolean useCacheForStaticFiles;
    public final int maxElementsLruCacheStaticFiles;
    private static final String CONFIG_ERROR_MESSAGE = "\n\n\n----------------------------------------------------------------\n----------------- System Configuration Missing -----------------\n----------------------------------------------------------------\n\nNo properties file found at ./minum.config\n\nContinuing, using defaults.  See source code for Minum for an\nexample minum.config, which will allow you to customize behavior.\n\n----------------------------------------------------------------\n----------------------------------------------------------------\n";

    public Constants() {
        this(null);
    }

    public Constants(Properties props) {
        this.properties = Objects.requireNonNullElseGet(props, Constants::getConfiguredProperties);
        this.serverPort = this.getProp("SERVER_PORT", 8080);
        this.secureServerPort = this.getProp("SSL_SERVER_PORT", 8443);
        this.hostName = this.properties.getProperty("HOST_NAME", "localhost");
        this.dbDirectory = this.properties.getProperty("DB_DIRECTORY", "db");
        this.staticFilesDirectory = this.properties.getProperty("STATIC_FILES_DIRECTORY", "static");
        this.logLevels = Constants.convertLoggingStringsToEnums(this.getProp("LOG_LEVELS", "DEBUG,TRACE,ASYNC_ERROR,AUDIT"));
        this.keystorePath = this.properties.getProperty("KEYSTORE_PATH", "");
        this.keystorePassword = this.properties.getProperty("KEYSTORE_PASSWORD", "");
        this.maxReadSizeBytes = this.getProp("MAX_READ_SIZE_BYTES", 0xA00000);
        this.maxReadLineSizeBytes = this.getProp("MAX_READ_LINE_SIZE_BYTES", 1024);
        this.socketTimeoutMillis = this.getProp("SOCKET_TIMEOUT_MILLIS", 7000);
        this.keepAliveTimeoutSeconds = this.getProp("KEEP_ALIVE_TIMEOUT_SECONDS", 3);
        this.vulnSeekingJailDuration = this.getProp("VULN_SEEKING_JAIL_DURATION", 10000);
        this.isTheBrigEnabled = this.getProp("IS_THE_BRIG_ENABLED", true);
        this.suspiciousErrors = this.getProp("SUSPICIOUS_ERRORS", "");
        this.suspiciousPaths = this.getProp("SUSPICIOUS_PATHS", "");
        this.startTime = System.currentTimeMillis();
        this.extraMimeMappings = this.getProp("EXTRA_MIME_MAPPINGS", "");
        this.staticFileCacheTime = this.getProp("STATIC_FILE_CACHE_TIME", 300);
        this.useCacheForStaticFiles = this.getProp("USE_CACHE_FOR_STATIC_FILES", true);
        this.maxElementsLruCacheStaticFiles = this.getProp("MAX_ELEMENTS_LRU_CACHE_STATIC_FILES", 1000);
    }

    private int getProp(String propName, int propDefault) {
        return Integer.parseInt(this.properties.getProperty(propName, String.valueOf(propDefault)));
    }

    private boolean getProp(String propName, boolean propDefault) {
        return Boolean.parseBoolean(this.properties.getProperty(propName, String.valueOf(propDefault)));
    }

    private List<String> getProp(String propName, String propDefault) {
        String propValue = this.properties.getProperty(propName);
        return Constants.extractList(propValue, propDefault);
    }

    static List<String> extractList(String propValue, String propDefault) {
        if (propValue == null) {
            if (propDefault.isBlank()) {
                return List.of();
            }
            return Arrays.asList(propDefault.trim().split("\\s*,\\s*"));
        }
        return Arrays.asList(propValue.trim().split("\\s*,\\s*"));
    }

    public static Properties getConfiguredProperties() {
        return Constants.getConfiguredProperties("minum.config");
    }

    static Properties getConfiguredProperties(String fileName) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(fileName);){
            System.out.println(TimeUtils.getTimestampIsoInstant() + " found properties file at ./minum.config.  Loading properties");
            props.load(fis);
        }
        catch (IOException ex) {
            System.out.println(CONFIG_ERROR_MESSAGE);
        }
        return props;
    }

    static List<LoggingLevel> convertLoggingStringsToEnums(List<String> logLevels) {
        List<String> logLevelStrings = logLevels.stream().map(String::toUpperCase).toList();
        ArrayList<LoggingLevel> enabledLoggingLevels = new ArrayList<LoggingLevel>();
        for (LoggingLevel t : LoggingLevel.values()) {
            if (!logLevelStrings.contains(t.name())) continue;
            enabledLoggingLevels.add(t);
        }
        return enabledLoggingLevels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constants constants = (Constants)o;
        return this.serverPort == constants.serverPort && this.secureServerPort == constants.secureServerPort && this.maxReadSizeBytes == constants.maxReadSizeBytes && this.maxReadLineSizeBytes == constants.maxReadLineSizeBytes && this.socketTimeoutMillis == constants.socketTimeoutMillis && this.keepAliveTimeoutSeconds == constants.keepAliveTimeoutSeconds && this.vulnSeekingJailDuration == constants.vulnSeekingJailDuration && this.isTheBrigEnabled == constants.isTheBrigEnabled && this.startTime == constants.startTime && this.staticFileCacheTime == constants.staticFileCacheTime && this.useCacheForStaticFiles == constants.useCacheForStaticFiles && this.maxElementsLruCacheStaticFiles == constants.maxElementsLruCacheStaticFiles && Objects.equals(this.properties, constants.properties) && Objects.equals(this.hostName, constants.hostName) && Objects.equals(this.dbDirectory, constants.dbDirectory) && Objects.equals(this.staticFilesDirectory, constants.staticFilesDirectory) && Objects.equals(this.logLevels, constants.logLevels) && Objects.equals(this.keystorePath, constants.keystorePath) && Objects.equals(this.keystorePassword, constants.keystorePassword) && Objects.equals(this.suspiciousErrors, constants.suspiciousErrors) && Objects.equals(this.suspiciousPaths, constants.suspiciousPaths) && Objects.equals(this.extraMimeMappings, constants.extraMimeMappings);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.serverPort, this.secureServerPort, this.hostName, this.dbDirectory, this.staticFilesDirectory, this.logLevels, this.keystorePath, this.keystorePassword, this.maxReadSizeBytes, this.maxReadLineSizeBytes, this.socketTimeoutMillis, this.keepAliveTimeoutSeconds, this.vulnSeekingJailDuration, this.isTheBrigEnabled, this.suspiciousErrors, this.suspiciousPaths, this.startTime, this.extraMimeMappings, this.staticFileCacheTime, this.useCacheForStaticFiles, this.maxElementsLruCacheStaticFiles);
    }
}

