/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.state;

import com.renomad.minum.database.Db;
import com.renomad.minum.database.DbData;
import com.renomad.minum.logging.ILogger;
import com.renomad.minum.queue.ActionQueueState;
import com.renomad.minum.state.Constants;
import com.renomad.minum.web.FullSystem;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;

public final class Context {
    public static final Context EMPTY = new Context(null, null);
    private ILogger logger;
    private final ExecutorService executorService;
    private final Constants constants;
    private FullSystem fullSystem;
    private final ActionQueueState actionQueueState;

    public Context(ExecutorService executorService, Constants constants) {
        this.executorService = executorService;
        this.constants = constants;
        this.actionQueueState = new ActionQueueState();
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Constants getConstants() {
        return this.constants;
    }

    public void setFullSystem(FullSystem fullSystem) {
        this.fullSystem = fullSystem;
    }

    public FullSystem getFullSystem() {
        return this.fullSystem;
    }

    public ActionQueueState getActionQueueState() {
        return this.actionQueueState;
    }

    public <T extends DbData<?>> Db<T> getDb(String name, T instance) {
        return new Db<T>(Path.of(this.constants.dbDirectory, name), this, instance);
    }
}

