/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.templating;

import com.renomad.minum.templating.RenderingResult;
import com.renomad.minum.templating.TemplateParseException;
import com.renomad.minum.templating.TemplateRenderException;
import com.renomad.minum.templating.TemplateSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class TemplateProcessor {
    private final List<TemplateSection> templateSections;

    private TemplateProcessor(List<TemplateSection> templateSections) {
        this.templateSections = templateSections;
    }

    public String renderTemplate(Map<String, String> myMap) {
        HashMap<String, Integer> usageMap = new HashMap<String, Integer>();
        ArrayList<String> parts = new ArrayList<String>();
        for (TemplateSection templateSection : this.templateSections) {
            RenderingResult result = templateSection.render(myMap);
            parts.add(result.renderedSection());
            String appliedKey = result.appliedKey();
            if (appliedKey == null) continue;
            usageMap.merge(appliedKey, 1, Integer::sum);
        }
        HashSet<String> unusedKeys = new HashSet<String>(myMap.keySet());
        unusedKeys.removeIf(usageMap.keySet()::contains);
        if (!unusedKeys.isEmpty()) {
            throw new TemplateRenderException("No corresponding key in template found for these keys: " + String.join((CharSequence)", ", unusedKeys));
        }
        return String.join((CharSequence)"", parts);
    }

    public static TemplateProcessor buildProcessor(String template) {
        ArrayList<TemplateSection> tSections = new ArrayList<TemplateSection>();
        int rowNumber = 1;
        int columnNumber = 1;
        int startOfKey = 0;
        StringBuilder builder = new StringBuilder();
        boolean isInsideTemplateKeyLiteral = false;
        for (int i = 0; i < template.length(); ++i) {
            char charAtCursor = template.charAt(i);
            if (TemplateProcessor.justArrivedInside(template, charAtCursor, i)) {
                isInsideTemplateKeyLiteral = true;
                startOfKey = columnNumber;
                ++i;
                builder = TemplateProcessor.processSectionInside(builder, tSections);
            } else if (TemplateProcessor.justArrivedOutside(template, charAtCursor, i, isInsideTemplateKeyLiteral)) {
                isInsideTemplateKeyLiteral = false;
                ++i;
                builder = TemplateProcessor.processSectionOutside(builder, tSections, startOfKey);
                startOfKey = 0;
            } else {
                builder.append(charAtCursor);
                if (i == template.length() - 1) {
                    if (isInsideTemplateKeyLiteral) {
                        String templateSample = template.length() > 10 ? template.substring(0, 10) + "..." : template;
                        throw new TemplateParseException("parsing failed for string starting with \"" + templateSample + "\" at line " + rowNumber + " and column " + columnNumber);
                    }
                    tSections.add(new TemplateSection(null, builder.toString(), 0));
                }
            }
            if (charAtCursor == '\n') {
                ++rowNumber;
                columnNumber = 1;
                continue;
            }
            ++columnNumber;
        }
        return new TemplateProcessor(tSections);
    }

    static StringBuilder processSectionInside(StringBuilder builder, List<TemplateSection> tSections) {
        if (!builder.isEmpty()) {
            tSections.add(new TemplateSection(null, builder.toString(), 0));
            builder = new StringBuilder();
        }
        return builder;
    }

    static StringBuilder processSectionOutside(StringBuilder builder, List<TemplateSection> tSections, int indent) {
        if (!builder.isEmpty()) {
            tSections.add(new TemplateSection(builder.toString().trim(), null, indent));
            builder = new StringBuilder();
        }
        return builder;
    }

    static boolean justArrivedOutside(String template, char charAtCursor, int i, boolean isInsideTemplateKeyLiteral) {
        return charAtCursor == '}' && i + 1 < template.length() && template.charAt(i + 1) == '}' && isInsideTemplateKeyLiteral;
    }

    static boolean justArrivedInside(String template, char charAtCursor, int i) {
        return charAtCursor == '{' && i + 1 < template.length() && template.charAt(i + 1) == '{';
    }
}

