/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.templating;

import com.renomad.minum.templating.RenderingResult;
import com.renomad.minum.templating.TemplateRenderException;
import com.renomad.minum.utils.Invariants;
import com.renomad.minum.utils.SerializationUtils;
import java.util.List;
import java.util.Map;

class TemplateSection {
    final String key;
    private final String subString;
    private final int indent;
    private RenderingResult result;
    static final int MAXIMUM_LINES_ALLOWED = 10000000;

    public TemplateSection(String key, String subString, int indent) {
        this.key = key;
        this.subString = subString;
        this.indent = indent;
    }

    public RenderingResult render(Map<String, String> myMap) {
        Invariants.mustBeTrue(this.subString != null || this.key != null, "Either the key or substring must exist");
        if (this.subString != null) {
            if (this.result == null) {
                Invariants.mustBeTrue(this.key == null, "If this object has a substring, then it must not have a key");
                this.result = new RenderingResult(this.subString, null);
            }
            return this.result;
        }
        String value = myMap.get(this.key);
        if (value == null) {
            throw new TemplateRenderException("Missing a value for key {" + this.key + "}");
        }
        List<String> lines = SerializationUtils.tokenizer(value, '\n', 10000000);
        StringBuilder stringBuilder = new StringBuilder(lines.getFirst());
        for (int i = 1; i < lines.size(); ++i) {
            if (lines.get(i).isEmpty()) {
                stringBuilder.append('\n');
                continue;
            }
            stringBuilder.append('\n').append(" ".repeat(this.indent - 1)).append(lines.get(i));
        }
        return new RenderingResult(stringBuilder.toString(), this.key);
    }
}

