/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.testing;

import com.renomad.minum.logging.TestLogger;
import com.renomad.minum.queue.ActionQueueKiller;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.testing.TestFailureException;
import com.renomad.minum.utils.ThrowingRunnable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class TestFramework {
    private TestFramework() {
    }

    public static <T> T assertThrows(Class<T> myEx, ThrowingRunnable r) {
        return TestFramework.assertThrows(myEx, null, r);
    }

    public static <T> T assertThrows(Class<T> myEx, String expectedMsg, ThrowingRunnable r) {
        try {
            r.run();
            throw new TestFailureException("Failed to throw exception");
        }
        catch (Exception ex) {
            if (!myEx.getTypeName().equals(ex.getClass().getTypeName())) {
                String msg = String.format("This did not throw the expected exception type (%s).  Instead, (%s) was thrown", myEx, ex);
                throw new TestFailureException(msg);
            }
            if (expectedMsg != null && !ex.getMessage().equals(expectedMsg)) {
                String msg = String.format("Did not get expected message (%s). Instead, got: %s", expectedMsg, ex.getMessage());
                throw new TestFailureException(msg);
            }
            return (T)ex;
        }
    }

    public static <T> void assertEquals(T left, T right) {
        if (!left.equals(right)) {
            throw new TestFailureException("Not equal! %nleft:  %s %nright: %s".formatted(TestFramework.showWhiteSpace(left.toString()), TestFramework.showWhiteSpace(right.toString())));
        }
    }

    public static void assertEqualByteArray(byte[] left, byte[] right) {
        if (left == null || right == null) {
            throw new TestFailureException("at least one of the inputs was null: left: %s right: %s".formatted(Arrays.toString(left), Arrays.toString(right)));
        }
        if (left.length != right.length) {
            throw new TestFailureException("Not equal! left length: %d right length: %d".formatted(left.length, right.length));
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            throw new TestFailureException("Not equal! at index %d left was: %d right was: %d".formatted(i, left[i], right[i]));
        }
    }

    public static void assertEqualByteArray(byte[] left, byte[] right, String failureMessage) {
        try {
            TestFramework.assertEqualByteArray(left, right);
        }
        catch (TestFailureException ex) {
            throw new TestFailureException(ex.getMessage() + ". " + failureMessage);
        }
    }

    public static void assertEqualsDisregardOrder(List<? extends CharSequence> left, List<? extends CharSequence> right) {
        if (left.size() != right.size()) {
            throw new TestFailureException(String.format("different sizes: left was %d, right was %d%n", left.size(), right.size()));
        }
        List orderedLeft = left.stream().sorted().toList();
        List orderedRight = right.stream().sorted().toList();
        for (int i = 0; i < left.size(); ++i) {
            if (((CharSequence)orderedLeft.get(i)).toString().contentEquals((CharSequence)orderedRight.get(i))) continue;
            throw new TestFailureException(String.format("%n%ndifferent values:%n%nleft:  %s%nright: %s%n%nfull left:%n-----------%n%s%n%nfull right:%n-----------%n%s%n", orderedLeft.get(i), orderedRight.get(i), String.join((CharSequence)"\n", TestFramework.showWhiteSpace(left.toString())), String.join((CharSequence)"\n", TestFramework.showWhiteSpace(right.toString()))));
        }
    }

    public static void assertEqualsDisregardOrder(List<? extends CharSequence> left, List<? extends CharSequence> right, String failureMessage) {
        try {
            TestFramework.assertEqualsDisregardOrder(left, right);
        }
        catch (TestFailureException ex) {
            throw new TestFailureException(ex.getMessage() + ". " + failureMessage);
        }
    }

    public static <T> void assertEquals(List<T> left, List<T> right) {
        TestFramework.assertEquals(left, right, "");
    }

    public static <T> void assertEquals(List<T> left, List<T> right, String failureMessage) {
        if (left.size() != right.size()) {
            throw new TestFailureException(String.format("different sizes: left was %d, right was %d. %s", left.size(), right.size(), failureMessage));
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i).equals(right.get(i))) continue;
            throw new TestFailureException(String.format("different values - left: \"%s\" right: \"%s\". %s", TestFramework.showWhiteSpace(left.get(i).toString()), TestFramework.showWhiteSpace(right.get(i).toString()), failureMessage));
        }
    }

    public static void assertTrue(boolean value) {
        TestFramework.assertTrue(value, "");
    }

    public static void assertTrue(boolean value, String failureMessage) {
        if (!value) {
            throw new TestFailureException(failureMessage);
        }
    }

    public static void assertFalse(boolean value) {
        if (value) {
            throw new TestFailureException("value was unexpectedly true");
        }
    }

    public static void assertFalse(boolean value, String failureMessage) {
        if (value) {
            throw new TestFailureException(failureMessage);
        }
    }

    static String showWhiteSpace(String msg) {
        if (msg == null) {
            return "(NULL)";
        }
        if (msg.isEmpty()) {
            return "(EMPTY)";
        }
        String text = msg.replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n");
        if (text.isBlank()) {
            return "(BLANK)";
        }
        return text;
    }

    public static Context buildTestingContext(String loggerName) {
        return TestFramework.buildTestingContext(loggerName, null);
    }

    public static Context buildTestingContext(String loggerName, Properties properties) {
        Constants constants = new Constants(properties);
        ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();
        TestLogger logger = new TestLogger(constants, executorService, loggerName);
        Context context = new Context(executorService, constants);
        context.setLogger(logger);
        return context;
    }

    public static void shutdownTestingContext(Context context) {
        new ActionQueueKiller(context).killAllQueues();
        context.getLogger().stop();
        context.getExecutorService().shutdownNow();
    }
}

