/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.utils.UtilsException;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class CryptoUtils {
    private CryptoUtils() {
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String createPasswordHash(String password, String salt) {
        return CryptoUtils.createPasswordHash(password, salt, "PBKDF2WithHmacSHA1");
    }

    static String createPasswordHash(String password, String salt, String algorithm) {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), 65536, 128);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
            byte[] hashed = factory.generateSecret(spec).getEncoded();
            return CryptoUtils.bytesToHex(hashed);
        }
        catch (Exception e) {
            throw new UtilsException(e);
        }
    }
}

