/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.utils.FileUtils;
import com.renomad.minum.utils.IFileReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public final class FileReader
implements IFileReader {
    private final Map<String, byte[]> lruCache;
    private final boolean useCacheForStaticFiles;
    private final ILogger logger;

    public FileReader(Map<String, byte[]> lruCache, boolean useCacheForStaticFiles, ILogger logger) {
        this.lruCache = lruCache;
        this.useCacheForStaticFiles = useCacheForStaticFiles;
        this.logger = logger;
    }

    @Override
    public byte[] readFile(String path) throws IOException {
        if (this.useCacheForStaticFiles && this.lruCache.containsKey(path)) {
            return this.lruCache.get(path);
        }
        try {
            FileUtils.checkForBadFilePatterns(path);
        }
        catch (Exception ex) {
            this.logger.logDebug(() -> String.format("Bad path requested at readFile: %s. Exception: %s", path, ex.getMessage()));
            return new byte[0];
        }
        if (!Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
            this.logger.logDebug(() -> String.format("No file found at %s, returning an empty byte array", path));
            return new byte[0];
        }
        return FileReader.readTheFile(path, this.logger, this.useCacheForStaticFiles, this.lruCache);
    }

    static byte[] readTheFile(String path, ILogger logger, boolean useCacheForStaticFiles, Map<String, byte[]> lruCache) throws IOException {
        try (RandomAccessFile reader = new RandomAccessFile(path, "r");){
            byte[] bytes;
            ByteArrayOutputStream out;
            block15: {
                byte[] byArray;
                out = new ByteArrayOutputStream();
                try {
                    FileChannel channel = reader.getChannel();
                    int bufferSize = 8192;
                    if ((long)bufferSize > channel.size()) {
                        bufferSize = (int)channel.size();
                    }
                    ByteBuffer buff = ByteBuffer.allocate(bufferSize);
                    while (channel.read(buff) > 0) {
                        out.write(buff.array(), 0, buff.position());
                        buff.clear();
                    }
                    bytes = out.toByteArray();
                    if (bytes.length != 0) break block15;
                    logger.logTrace(() -> path + " filesize was 0, returning empty byte array");
                    byArray = new byte[]{};
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                out.close();
                return byArray;
            }
            String s = path + " filesize was " + bytes.length + " bytes.";
            logger.logTrace(() -> s);
            if (useCacheForStaticFiles) {
                logger.logDebug(() -> "Storing " + path + " in the cache");
                lruCache.put(path, bytes);
            }
            byte[] byArray = bytes;
            out.close();
            return byArray;
        }
    }
}

