/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.state.Constants;
import com.renomad.minum.utils.FileReader;
import com.renomad.minum.utils.IFileReader;
import com.renomad.minum.utils.InvariantException;
import com.renomad.minum.utils.LRUCache;
import com.renomad.minum.utils.UtilsException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class FileUtils {
    public static final Pattern badFilePathPatterns = Pattern.compile("//|\\.\\.|:|^/|^\\\\");
    private final ILogger logger;
    private final IFileReader fileReader;

    public FileUtils(ILogger logger, Constants constants) {
        this(logger, new FileReader(LRUCache.getLruCache(constants.maxElementsLruCacheStaticFiles), constants.useCacheForStaticFiles, logger));
    }

    FileUtils(ILogger logger, IFileReader fileReader) {
        this.logger = logger;
        this.fileReader = fileReader;
    }

    public void writeString(Path path, String content) {
        if (path.toString().isEmpty()) {
            this.logger.logDebug(() -> "an empty path was provided to writeString");
            return;
        }
        try {
            Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UtilsException(e);
        }
    }

    public void deleteDirectoryRecursivelyIfExists(Path myPath) {
        if (!Files.exists(myPath, new LinkOption[0])) {
            this.logger.logDebug(() -> "system was requested to delete directory: " + String.valueOf(myPath) + ", but it did not exist");
        } else {
            this.walkPathDeleting(myPath);
        }
    }

    void walkPathDeleting(Path myPath) {
        try (Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);){
            List<File> files = walk.sorted(Comparator.reverseOrder()).map(Path::toFile).toList();
            for (File file : files) {
                this.logger.logDebug(() -> "deleting " + String.valueOf(file));
                Files.delete(file.toPath());
            }
        }
        catch (IOException ex) {
            throw new UtilsException("Error during deleteDirectoryRecursivelyIfExists: " + String.valueOf(ex));
        }
    }

    public void makeDirectory(Path directory) {
        this.logger.logDebug(() -> "Creating a directory " + String.valueOf(directory));
        boolean directoryExists = Files.exists(directory, new LinkOption[0]);
        this.logger.logDebug(() -> "Directory: " + String.valueOf(directory) + ". Already exists: " + String.valueOf(directory));
        if (!directoryExists) {
            this.logger.logDebug(() -> "Creating directory, since it does not already exist: " + String.valueOf(directory));
            FileUtils.innerCreateDirectory(directory);
            this.logger.logDebug(() -> "Directory: " + String.valueOf(directory) + " created");
        }
    }

    static void innerCreateDirectory(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e);
        }
    }

    public byte[] readBinaryFile(String path) {
        try {
            return this.fileReader.readFile(path);
        }
        catch (IOException e) {
            this.logger.logDebug(() -> String.format("Error while reading file %s, returning empty byte array. %s", path, e));
            return new byte[0];
        }
    }

    public String readTextFile(String path) {
        try {
            return new String(this.fileReader.readFile(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.logDebug(() -> String.format("Error while reading file %s, returning empty string. %s", path, e));
            return "";
        }
    }

    public static void checkFileIsWithinDirectory(String path, String directoryPath) {
        Path fullRealPath;
        Path directoryRealPath;
        try {
            directoryRealPath = Path.of(directoryPath, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
            fullRealPath = directoryRealPath.resolve(path).toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException ex) {
            throw new InvariantException(ex.toString());
        }
        if (!fullRealPath.startsWith(directoryRealPath)) {
            throw new InvariantException(String.format("path (%s) was not within directory (%s)", path, directoryPath));
        }
    }

    public static void checkForBadFilePatterns(String path) {
        if (path.isBlank()) {
            throw new InvariantException("filename was empty");
        }
        if (badFilePathPatterns.matcher(path).find()) {
            throw new InvariantException("filename (" + path + ") contained invalid characters");
        }
        for (char c : path.toCharArray()) {
            boolean isWhitelistedChar;
            boolean bl = isWhitelistedChar = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '\\' || c == '/';
            if (isWhitelistedChar) continue;
            throw new InvariantException("filename (" + path + ") contained invalid characters (" + c + ").  Allowable characters are alpha-numeric ascii both cases, underscore, forward and backward-slash, period, and dash");
        }
    }

    public static Path safeResolve(String parentDirectory, String path) {
        FileUtils.checkForBadFilePatterns(path);
        FileUtils.checkFileIsWithinDirectory(path, parentDirectory);
        return Path.of(parentDirectory, new String[0]).resolve(path);
    }
}

