/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.utils.UtilsException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RingBuffer<T>
implements Iterable<T> {
    private final int limit;
    private final int lastIndex;
    private final T[] innerArray;
    private int nextIndex;

    public RingBuffer(int limit, Class<T> clazz) {
        this.limit = limit;
        this.lastIndex = limit - 1;
        Object[] t = (Object[])Array.newInstance(clazz, limit);
        this.innerArray = t;
        this.nextIndex = 0;
    }

    private int incrementIndex(int index) {
        if (index == this.lastIndex) {
            return 0;
        }
        return index + 1;
    }

    public void add(T item) {
        this.innerArray[this.nextIndex] = item;
        this.nextIndex = this.incrementIndex(this.nextIndex);
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean contains(List<T> myList) {
        if (myList == null || myList.isEmpty()) {
            throw new UtilsException("expected a valid non-empty list to search for in the RingBuffer");
        }
        int myListIndex = 0;
        int myListLength = myList.size();
        for (T value : this) {
            myListIndex = myList.get(myListIndex).equals(value) ? ++myListIndex : 0;
            if (myListIndex != myListLength) continue;
            return true;
        }
        return false;
    }

    public boolean containsAt(List<T> myList, int index) {
        if (myList == null || myList.isEmpty()) {
            throw new UtilsException("expected a valid non-empty list to search for in the RingBuffer");
        }
        if (index > this.lastIndex || index < 0) {
            throw new UtilsException("expected an index greater than zero and less-than-or-equal to the last index of the buffer (the limit minus one)");
        }
        int i = 0;
        int myListIndex = 0;
        int myListLastIndex = myList.size() - 1;
        boolean comparing = false;
        Iterator<T> iterator = this.iterator();
        while (true) {
            T value = iterator.next();
            if (i == index) {
                comparing = true;
            }
            if (comparing) {
                if (!myList.get(myListIndex).equals(value)) {
                    return false;
                }
                if (myListIndex == myListLastIndex) {
                    return true;
                }
                ++myListIndex;
            }
            ++i;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int iteratorIndex;
            int count;
            {
                this.iteratorIndex = RingBuffer.this.nextIndex;
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                return this.count < RingBuffer.this.limit;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = RingBuffer.this.innerArray[this.iteratorIndex];
                this.iteratorIndex = RingBuffer.this.incrementIndex(this.iteratorIndex);
                ++this.count;
                return result;
            }
        };
    }

    public T atNextIndex() {
        return this.innerArray[this.nextIndex];
    }
}

