/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.utils.Invariants;
import com.renomad.minum.utils.UtilsException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static <T> T findExactlyOne(Stream<T> streamOfSomething, Predicate<? super T> searchPredicate) {
        return (T)SearchUtils.findExactlyOne(streamOfSomething, searchPredicate, () -> null);
    }

    public static <T> T findExactlyOne(Stream<T> streamOfSomething, Predicate<? super T> searchPredicate, Callable<T> alternate) {
        List<T> listOfThings = streamOfSomething.filter(Objects::nonNull).filter(searchPredicate).toList();
        Invariants.mustBeTrue(listOfThings.isEmpty() || listOfThings.size() == 1, "Must be zero or one of this thing, or it's a bug.  We found a size of " + listOfThings.size());
        if (listOfThings.isEmpty()) {
            T returnValue;
            try {
                returnValue = alternate.call();
            }
            catch (Exception ex) {
                throw new UtilsException(ex);
            }
            return returnValue;
        }
        return listOfThings.getFirst();
    }
}

