/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static String serializeHelper(Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length - 1; ++i) {
            String value = values[i] == null ? null : values[i].toString();
            sb.append(StringUtils.encode(value)).append("|");
        }
        String lastValue = values[values.length - 1] == null ? null : values[values.length - 1].toString();
        sb.append(StringUtils.encode(lastValue));
        return sb.toString();
    }

    public static List<String> deserializeHelper(String serializedText) {
        int maximumDatabasePartitionsAllowed = 200;
        return SerializationUtils.tokenizer(serializedText, '|', maximumDatabasePartitionsAllowed).stream().map(StringUtils::decode).toList();
    }

    public static List<String> tokenizer(String serializedText, char delimiter, int maxTokens) {
        ArrayList<String> resultList = new ArrayList<String>();
        int currentPlace = 0;
        int i = 0;
        while (true) {
            if (i >= maxTokens) {
                throw new ForbiddenUseException("Asked to split content into too many partitions in the tokenizer.  Current max: " + maxTokens);
            }
            int nextDelimiterIndex = serializedText.indexOf(delimiter, currentPlace);
            if (nextDelimiterIndex == -1) break;
            resultList.add(serializedText.substring(currentPlace, nextDelimiterIndex));
            currentPlace = nextDelimiterIndex + 1;
            ++i;
        }
        resultList.add(serializedText.substring(currentPlace));
        return resultList;
    }
}

