/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.utils;

import com.renomad.minum.utils.Invariants;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StringUtils {
    private StringUtils() {
    }

    public static String safeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String safeAttr(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    public static String encode(String str) {
        if (str == null) {
            return "%NULL%";
        }
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    public static String decode(String str) {
        Invariants.mustNotBeNull(str);
        if (str.equals("%NULL%")) {
            return null;
        }
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static String generateSecureRandomString(int length) {
        String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom sr = new SecureRandom();
        return IntStream.range(1, length + 1).mapToObj(x -> Character.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(sr.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length())))).map(Object::toString).collect(Collectors.joining());
    }

    public static String byteListToString(List<Byte> byteList) {
        if (byteList == null) {
            return null;
        }
        int size = byteList.size();
        byte[] buf = new byte[size];
        for (int i = 0; i < size; ++i) {
            buf[i] = byteList.get(i);
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    public static String byteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        return new String(byteArray, StandardCharsets.UTF_8);
    }
}

