/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.utils.StringUtils;
import com.renomad.minum.web.BodyType;
import com.renomad.minum.web.Partition;
import com.renomad.minum.web.WebServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Body {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Map<String, byte[]> bodyMap;
    private final byte[] raw;
    private final List<Partition> partitions;
    private final BodyType bodyType;
    public static final Body EMPTY = new Body(Map.of(), EMPTY_BYTES, List.of(), BodyType.NONE);

    public Body(Map<String, byte[]> bodyMap, byte[] raw, List<Partition> partitions, BodyType bodyType) {
        this.bodyMap = new HashMap<String, byte[]>(bodyMap);
        this.raw = (byte[])raw.clone();
        this.partitions = partitions;
        this.bodyType = bodyType;
    }

    public String asString(String key) {
        if (this.equals(EMPTY)) {
            return "";
        }
        if (this.bodyType.equals((Object)BodyType.MULTIPART)) {
            throw new WebServerException("Request body is in multipart format.  Use .getPartitionByName instead");
        }
        if (this.bodyType.equals((Object)BodyType.UNRECOGNIZED)) {
            throw new WebServerException("Request body is not in a recognized key-value encoding.  Use .asString() to obtain the body data");
        }
        byte[] byteArray = this.bodyMap.get(key);
        if (byteArray == null) {
            return "";
        }
        return StringUtils.byteArrayToString(byteArray).trim();
    }

    public String asString() {
        if (this.equals(EMPTY)) {
            return "";
        }
        return StringUtils.byteArrayToString(this.raw).trim();
    }

    public byte[] asBytes(String key) {
        if (this.equals(EMPTY)) {
            return new byte[0];
        }
        if (this.bodyType.equals((Object)BodyType.MULTIPART)) {
            throw new WebServerException("Request body is in multipart format.  Use .getPartitionByName instead");
        }
        if (this.bodyType.equals((Object)BodyType.UNRECOGNIZED)) {
            throw new WebServerException("Request body is not in a recognized key-value encoding.  Use .asBytes() to obtain the body data");
        }
        return this.bodyMap.get(key);
    }

    public byte[] asBytes() {
        if (this.equals(EMPTY)) {
            return new byte[0];
        }
        return (byte[])this.raw.clone();
    }

    public List<Partition> getPartitionHeaders() {
        if (this.equals(EMPTY)) {
            return List.of();
        }
        if (this.bodyType.equals((Object)BodyType.FORM_URL_ENCODED)) {
            throw new WebServerException("Request body encoded in form-urlencoded format. getPartitionHeaders is only used with multipart encoded data.");
        }
        if (this.bodyType.equals((Object)BodyType.UNRECOGNIZED)) {
            throw new WebServerException("Request body encoded is not encoded in a recognized format. getPartitionHeaders is only used with multipart encoded data.");
        }
        return new ArrayList<Partition>(this.partitions);
    }

    public List<Partition> getPartitionByName(String name) {
        if (this.equals(EMPTY)) {
            return List.of();
        }
        if (this.bodyType.equals((Object)BodyType.FORM_URL_ENCODED)) {
            throw new WebServerException("Request body encoded in form-urlencoded format. use .asString(key) or asBytes(key)");
        }
        if (this.bodyType.equals((Object)BodyType.UNRECOGNIZED)) {
            throw new WebServerException("Request body encoded is not encoded in a recognized format. use .asString() or asBytes()");
        }
        return this.getPartitionHeaders().stream().filter(x -> x.getContentDisposition().getName().equalsIgnoreCase(name)).toList();
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public Set<String> getKeys() {
        if (this.equals(EMPTY)) {
            return Set.of();
        }
        return this.bodyMap.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body body = (Body)o;
        return Objects.equals(this.bodyMap, body.bodyMap) && Arrays.equals(this.raw, body.raw) && Objects.equals(this.partitions, body.partitions) && this.bodyType == body.bodyType;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.bodyMap, this.partitions, this.bodyType});
        result = 31 * result + Arrays.hashCode(this.raw);
        return result;
    }

    public String toString() {
        return "Body{bodyMap=" + String.valueOf(this.bodyMap) + ", bodyType=" + String.valueOf((Object)this.bodyType) + "}";
    }
}

