/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.logging.Logger;
import com.renomad.minum.queue.ActionQueueKiller;
import com.renomad.minum.security.ITheBrig;
import com.renomad.minum.security.TheBrig;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.FileUtils;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.utils.TimeUtils;
import com.renomad.minum.web.IServer;
import com.renomad.minum.web.WebEngine;
import com.renomad.minum.web.WebFramework;
import com.renomad.minum.web.WebServerException;
import java.io.File;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class FullSystem {
    final ILogger logger;
    private final Constants constants;
    private final FileUtils fileUtils;
    private IServer server;
    private WebFramework webFramework;
    private IServer sslServer;
    Thread shutdownHook;
    private ITheBrig theBrig;
    final ExecutorService es;
    private WebEngine webEngine;
    private boolean hasShutdown;
    private final Context context;

    public FullSystem(Context context) {
        this.logger = context.getLogger();
        this.constants = context.getConstants();
        this.fileUtils = new FileUtils(this.logger, this.constants);
        this.es = context.getExecutorService();
        this.context = context;
        context.setFullSystem(this);
    }

    public static Context buildContext() {
        Constants constants = new Constants();
        ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();
        Logger logger = new Logger(constants, executorService, "primary logger");
        Context context = new Context(executorService, constants);
        context.setLogger(logger);
        return context;
    }

    public static FullSystem initialize() {
        Context context = FullSystem.buildContext();
        FullSystem fullSystem = new FullSystem(context);
        return fullSystem.start();
    }

    public FullSystem start() {
        this.createSystemRunningMarker();
        this.addShutdownHook();
        String serverComment = "at http://" + this.constants.hostName + ":" + this.constants.serverPort + " and https://" + this.constants.hostName + ":" + this.constants.secureServerPort;
        this.logger.logDebug(() -> " *** Minum is starting " + serverComment + " ***");
        this.theBrig = new TheBrig(this.context).initialize();
        this.webFramework = new WebFramework(this.context);
        this.webEngine = new WebEngine(this.context, this.webFramework);
        this.server = this.webEngine.startServer();
        this.sslServer = this.webEngine.startSslServer();
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        long nowMillis = now.toInstant().toEpochMilli();
        long startupTime = nowMillis - this.constants.startTime;
        this.logger.logDebug(() -> " *** Minum has finished primary startup after " + startupTime + " milliseconds ***");
        return this;
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(ThrowingRunnable.throwingRunnableWrapper(this::shutdown, this.logger));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void createSystemRunningMarker() {
        this.fileUtils.writeString(Path.of("SYSTEM_RUNNING", new String[0]), "This file serves as a marker to indicate the system is running.\n");
        new File("SYSTEM_RUNNING").deleteOnExit();
    }

    IServer getServer() {
        return this.server;
    }

    IServer getSslServer() {
        return this.sslServer;
    }

    public WebFramework getWebFramework() {
        return this.webFramework;
    }

    public ITheBrig getTheBrig() {
        return this.theBrig;
    }

    public Context getContext() {
        return this.context;
    }

    WebEngine getWebEngine() {
        return this.webEngine;
    }

    public void shutdown() {
        if (!this.hasShutdown) {
            this.logger.logTrace(() -> "close called on " + String.valueOf(this));
            FullSystem.closeCore(this.logger, this.context, this.server, this.sslServer, this.toString());
            this.hasShutdown = true;
        }
    }

    static void closeCore(ILogger logger, Context context, IServer server, IServer sslServer, String fullSystemName) {
        try {
            logger.logDebug(() -> "Received shutdown command");
            logger.logDebug(() -> " Stopping the server: " + String.valueOf(server));
            server.close();
            logger.logDebug(() -> " Stopping the SSL server: " + String.valueOf(server));
            sslServer.close();
            logger.logDebug(() -> "Killing all the action queues: " + context.getActionQueueState().aqQueueAsString());
            new ActionQueueKiller(context).killAllQueues();
            logger.logDebug(() -> String.format("%s %s says: Goodbye world!%n", TimeUtils.getTimestampIsoInstant(), fullSystemName));
        }
        catch (Exception e) {
            throw new WebServerException(e);
        }
    }

    public void block() {
        FullSystem.blockCore(this.server, this.sslServer);
    }

    static void blockCore(IServer server, IServer sslServer) {
        try {
            server.getCentralLoopFuture().get();
            sslServer.getCentralLoopFuture().get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ex) {
            Thread.currentThread().interrupt();
            throw new WebServerException(ex);
        }
    }

    public String toString() {
        return super.toString();
    }
}

