/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.htmlparsing.HtmlParseNode;
import com.renomad.minum.htmlparsing.HtmlParser;
import com.renomad.minum.htmlparsing.TagName;
import com.renomad.minum.logging.ILogger;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.InvariantException;
import com.renomad.minum.utils.StacktraceUtils;
import com.renomad.minum.web.Body;
import com.renomad.minum.web.BodyProcessor;
import com.renomad.minum.web.Headers;
import com.renomad.minum.web.IBodyProcessor;
import com.renomad.minum.web.IInputStreamUtils;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.InputStreamUtils;
import com.renomad.minum.web.RequestLine;
import com.renomad.minum.web.SocketWrapper;
import com.renomad.minum.web.StatusLine;
import com.renomad.minum.web.WebFramework;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class FunctionalTesting {
    private final String host;
    private final int port;
    private final IInputStreamUtils inputStreamUtils;
    private final ILogger logger;
    private final Constants constants;
    private final IBodyProcessor bodyProcessor;

    public FunctionalTesting(Context context, String host, int port) {
        this.constants = context.getConstants();
        this.host = host;
        this.port = port;
        this.inputStreamUtils = new InputStreamUtils(this.constants.maxReadLineSizeBytes);
        this.logger = context.getLogger();
        this.bodyProcessor = new BodyProcessor(context);
    }

    public TestResponse get(String path) {
        ArrayList<String> headers = new ArrayList<String>();
        return this.send(RequestLine.Method.GET, path, new byte[0], headers);
    }

    public TestResponse get(String path, List<String> extraHeaders) {
        return this.send(RequestLine.Method.GET, path, new byte[0], extraHeaders);
    }

    public TestResponse post(String path, String payload) {
        ArrayList<String> headers = new ArrayList<String>();
        return this.post(path, payload, headers);
    }

    public TestResponse post(String path, String payload, List<String> extraHeaders) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Content-Type: application/x-www-form-urlencoded");
        headers.addAll(extraHeaders);
        return this.send(RequestLine.Method.POST, path, payload.getBytes(StandardCharsets.UTF_8), headers);
    }

    public TestResponse send(RequestLine.Method method, String path) {
        return this.send(method, path, new byte[0], List.of());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TestResponse send(RequestLine.Method method, String path, byte[] payload, List<String> extraHeaders) {
        try (Socket socket = new Socket(this.host, this.port);){
            TestResponse testResponse;
            block13: {
                ISocketWrapper client = this.startClient(socket);
                try {
                    testResponse = this.innerClientSend(client, method, path, payload, extraHeaders);
                    if (client == null) break block13;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            return testResponse;
        }
        catch (Exception e) {
            this.logger.logDebug(() -> "Error during client send: " + StacktraceUtils.stackTraceToString(e));
            return TestResponse.EMPTY;
        }
    }

    ISocketWrapper startClient(Socket socket) throws IOException {
        this.logger.logDebug(() -> String.format("Just created new client socket: %s", socket));
        return new SocketWrapper(socket, null, this.logger, this.constants.socketTimeoutMillis, this.constants.hostName);
    }

    public TestResponse innerClientSend(ISocketWrapper client, RequestLine.Method method, String path, byte[] payload, List<String> extraHeaders) throws IOException {
        Body body = Body.EMPTY;
        InputStream is = client.getInputStream();
        client.sendHttpLine(String.valueOf((Object)method) + " /" + path + " HTTP/1.1");
        client.sendHttpLine(String.format("Host: %s:%d", this.host, this.port));
        client.sendHttpLine("Content-Length: " + payload.length);
        for (String header : extraHeaders) {
            client.sendHttpLine(header);
        }
        client.sendHttpLine("");
        client.send(payload);
        StatusLine statusLine = StatusLine.extractStatusLine(this.inputStreamUtils.readLine(is));
        List<String> allHeaders = Headers.getAllHeaders(is, this.inputStreamUtils);
        Headers headers = new Headers(allHeaders);
        if (WebFramework.isThereIsABody(headers) && method != RequestLine.Method.HEAD) {
            this.logger.logTrace(() -> "There is a body. Content-type is " + headers.contentType());
            body = this.bodyProcessor.extractData(is, headers);
        }
        return new TestResponse(statusLine, headers, body);
    }

    public record TestResponse(StatusLine statusLine, Headers headers, Body body) {
        public static final TestResponse EMPTY = new TestResponse(StatusLine.EMPTY, Headers.EMPTY, Body.EMPTY);

        public HtmlParseNode searchOne(TagName tagName, Map<String, String> attributes) {
            HtmlParser htmlParser = new HtmlParser();
            List<HtmlParseNode> nodes = htmlParser.parse(this.body.asString());
            List<HtmlParseNode> searchResults = htmlParser.search(nodes, tagName, attributes);
            if (searchResults.size() > 1) {
                throw new InvariantException("More than 1 node found.  Here they are:" + String.valueOf(searchResults));
            }
            if (searchResults.isEmpty()) {
                return HtmlParseNode.EMPTY;
            }
            return searchResults.getFirst();
        }

        public List<HtmlParseNode> search(TagName tagName, Map<String, String> attributes) {
            HtmlParser htmlParser = new HtmlParser();
            List<HtmlParseNode> nodes = htmlParser.parse(this.body.asString());
            return htmlParser.search(nodes, tagName, attributes);
        }
    }
}

