/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.utils.Invariants;
import com.renomad.minum.web.IInputStreamUtils;
import com.renomad.minum.web.WebServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Headers {
    public static final Headers EMPTY = new Headers(List.of());
    private static final int MAX_HEADERS_COUNT = 70;
    private final List<String> headerStrings;
    private final Map<String, List<String>> headersMap;
    private static final Pattern contentLengthRegex = Pattern.compile("^[cC]ontent-[lL]ength: (.*)$");

    public Headers(List<String> headerStrings) {
        this.headerStrings = new ArrayList<String>(headerStrings);
        this.headersMap = Collections.unmodifiableMap(Headers.extractHeadersToMap(headerStrings));
    }

    public List<String> getHeaderStrings() {
        return new ArrayList<String>(this.headerStrings);
    }

    static Map<String, List<String>> extractHeadersToMap(List<String> headerStrings) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String h : headerStrings) {
            int indexOfFirstColon = h.indexOf(":");
            if (indexOfFirstColon <= 0) continue;
            String key = h.substring(0, indexOfFirstColon).toLowerCase(Locale.ROOT);
            String value = h.substring(indexOfFirstColon + 1).trim();
            if (result.containsKey(key)) {
                List<String> currentValue = result.get(key);
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(value);
                newList.addAll(currentValue);
                result.put(key, newList);
                continue;
            }
            result.put(key, List.of(value));
        }
        return result;
    }

    public String contentType() {
        List<String> cts = this.headerStrings.stream().filter(x -> x.toLowerCase(Locale.ROOT).startsWith("content-type")).toList();
        if (cts.size() > 1) {
            throw new WebServerException("The number of content-type headers must be exactly zero or one.  Received: " + String.valueOf(cts));
        }
        if (!cts.isEmpty()) {
            return cts.getFirst();
        }
        return "";
    }

    public int contentLength() {
        List<String> cl = this.headerStrings.stream().filter(x -> x.toLowerCase(Locale.ROOT).startsWith("content-length")).toList();
        if (cl.size() > 1) {
            throw new WebServerException("The number of content-length headers must be exactly zero or one.  Received: " + String.valueOf(cl));
        }
        int contentLength = -1;
        if (!cl.isEmpty()) {
            Matcher clMatcher = contentLengthRegex.matcher(cl.getFirst());
            Invariants.mustBeTrue(clMatcher.matches(), "The content length header value must match the contentLengthRegex");
            contentLength = Integer.parseInt(clMatcher.group(1));
            Invariants.mustBeTrue(contentLength >= 0, "Content-length cannot be negative");
        }
        return contentLength;
    }

    public boolean hasKeepAlive() {
        List<String> connectionHeader = this.headersMap.get("connection");
        if (connectionHeader == null) {
            return false;
        }
        return connectionHeader.stream().anyMatch(x -> x.toLowerCase(Locale.ROOT).contains("keep-alive"));
    }

    public boolean hasConnectionClose() {
        List<String> connectionHeader = this.headersMap.get("connection");
        if (connectionHeader == null) {
            return false;
        }
        return connectionHeader.stream().anyMatch(x -> x.toLowerCase(Locale.ROOT).contains("close"));
    }

    static List<String> getAllHeaders(InputStream is, IInputStreamUtils inputStreamUtils) {
        ArrayList<String> headers = new ArrayList<String>();
        int i = 0;
        while (true) {
            String value;
            if (i >= 70) {
                throw new ForbiddenUseException("User tried sending too many headers.  max: 70");
            }
            try {
                value = inputStreamUtils.readLine(is);
            }
            catch (IOException e) {
                throw new WebServerException(e);
            }
            if (value != null && value.isBlank()) break;
            if (value == null) {
                return headers;
            }
            headers.add(value);
            ++i;
        }
        return headers;
    }

    public List<String> valueByKey(String key) {
        return this.headersMap.get(key.toLowerCase(Locale.ROOT));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.headerStrings, headers.headerStrings) && Objects.equals(this.headersMap, headers.headersMap);
    }

    public int hashCode() {
        return Objects.hash(this.headerStrings, this.headersMap);
    }

    public String toString() {
        return "Headers{headerStrings=" + String.valueOf(this.headerStrings) + "}";
    }
}

