/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.utils.UtilsException;
import com.renomad.minum.web.IInputStreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class InputStreamUtils
implements IInputStreamUtils {
    private final int maxReadLineSizeBytes;

    public InputStreamUtils(int maxReadLineSizeBytes) {
        this.maxReadLineSizeBytes = maxReadLineSizeBytes;
    }

    @Override
    public String readLine(InputStream inputStream) throws IOException {
        int NEWLINE_DECIMAL = 10;
        int CARRIAGE_RETURN_DECIMAL = 13;
        ByteArrayOutputStream result = new ByteArrayOutputStream(this.maxReadLineSizeBytes / 3);
        int i = 0;
        while (true) {
            if (i >= this.maxReadLineSizeBytes) {
                inputStream.close();
                throw new ForbiddenUseException("client sent more bytes than allowed for a single line.  max: " + this.maxReadLineSizeBytes);
            }
            int a = inputStream.read();
            if (a == -1) {
                return result.toString(StandardCharsets.UTF_8);
            }
            if (a != 13) {
                if (a == 10) break;
                result.write(a);
            }
            ++i;
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] read(int lengthToRead, InputStream inputStream) {
        int typicalBufferSize = 8192;
        byte[] buf = new byte[Math.min(lengthToRead, 8192)];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read;
            while ((read = inputStream.read(buf)) >= 0) {
                if ((totalRead += read) < lengthToRead) {
                    baos.write(buf, 0, read);
                    continue;
                }
                baos.write(buf, 0, read - (totalRead - lengthToRead));
                break;
            }
        }
        catch (IOException ex) {
            throw new UtilsException(ex);
        }
        byte[] data = baos.toByteArray();
        if (data.length != lengthToRead) {
            String message = String.format("length of bytes read (%d) must be what we expected (%d)", data.length, lengthToRead);
            throw new ForbiddenUseException(message);
        }
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputStreamUtils that = (InputStreamUtils)o;
        return this.maxReadLineSizeBytes == that.maxReadLineSizeBytes;
    }

    public int hashCode() {
        return Objects.hash(this.maxReadLineSizeBytes);
    }
}

