/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.utils.StringUtils;
import com.renomad.minum.web.ContentDisposition;
import com.renomad.minum.web.Headers;
import java.util.Arrays;
import java.util.Objects;

public final class Partition {
    private final Headers headers;
    private final byte[] content;
    private final ContentDisposition contentDisposition;

    public Partition(Headers headers, byte[] content, ContentDisposition contentDisposition) {
        this.headers = headers;
        this.content = content;
        this.contentDisposition = contentDisposition;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public byte[] getContent() {
        return (byte[])this.content.clone();
    }

    public String getContentAsString() {
        return StringUtils.byteArrayToString(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.headers, partition.headers) && Arrays.equals(this.content, partition.content) && Objects.equals(this.contentDisposition, partition.contentDisposition);
    }

    public int hashCode() {
        int result = Objects.hash(this.headers, this.contentDisposition);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    public String toString() {
        return "Partition{headers=" + String.valueOf(this.headers) + ", contentDisposition=" + String.valueOf(this.contentDisposition) + "}";
    }
}

