/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.web.Headers;
import com.renomad.minum.web.InvalidRangeException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Range {
    private static final Pattern rangeHeaderPattern = Pattern.compile("^bytes=(?<first>[0-9]{0,13})-(?<second>[0-9]{0,13})$");
    private final Long rangeFirstPart;
    private final Long rangeSecondPart;
    private final Long length;
    private final Long offset;
    private final boolean hasRangeHeader;

    public Range(Headers requestHeaders, long fullLength) {
        List<String> rangeHeaders = requestHeaders.valueByKey("range");
        if (rangeHeaders == null) {
            this.hasRangeHeader = false;
            this.rangeFirstPart = null;
            this.rangeSecondPart = null;
            this.length = fullLength;
            this.offset = 0L;
        } else {
            this.hasRangeHeader = true;
            if (rangeHeaders.size() > 1) {
                throw new InvalidRangeException("Error: Request contained more than one Range header");
            }
            Matcher matcher = rangeHeaderPattern.matcher(rangeHeaders.getFirst());
            if (matcher.matches()) {
                String firstPart = matcher.group("first");
                String secondPart = matcher.group("second");
                this.rangeFirstPart = !firstPart.isEmpty() ? Long.valueOf(Long.parseLong(firstPart)) : null;
                this.rangeSecondPart = !secondPart.isEmpty() ? Long.valueOf(Long.parseLong(secondPart)) : null;
                if (this.rangeFirstPart != null && this.rangeSecondPart != null) {
                    if (this.rangeFirstPart > this.rangeSecondPart) {
                        throw new InvalidRangeException("Error: The value of the first part of the range was larger than the second.");
                    }
                    this.length = this.rangeSecondPart - this.rangeFirstPart + 1L;
                    this.offset = this.rangeFirstPart;
                } else if (this.rangeFirstPart != null) {
                    this.offset = this.rangeFirstPart;
                    this.length = fullLength - this.offset;
                } else if (this.rangeSecondPart != null) {
                    this.offset = fullLength - this.rangeSecondPart;
                    this.length = this.rangeSecondPart;
                } else {
                    this.length = fullLength;
                    this.offset = 0L;
                }
            } else {
                this.rangeFirstPart = null;
                this.rangeSecondPart = null;
                this.length = fullLength;
                this.offset = 0L;
            }
        }
    }

    public Long getRangeFirstPart() {
        return this.rangeFirstPart;
    }

    public Long getRangeSecondPart() {
        return this.rangeSecondPart;
    }

    public Long getLength() {
        return this.length;
    }

    public Long getOffset() {
        return this.offset;
    }

    public boolean hasRangeHeader() {
        return this.hasRangeHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.hasRangeHeader == range.hasRangeHeader && Objects.equals(this.rangeFirstPart, range.rangeFirstPart) && Objects.equals(this.rangeSecondPart, range.rangeSecondPart) && Objects.equals(this.length, range.length) && Objects.equals(this.offset, range.offset);
    }

    public int hashCode() {
        return Objects.hash(this.rangeFirstPart, this.rangeSecondPart, this.length, this.offset, this.hasRangeHeader);
    }

    public String toString() {
        return "Range{rangeFirstPart=" + this.rangeFirstPart + ", rangeSecondPart=" + this.rangeSecondPart + ", length=" + this.length + ", offset=" + this.offset + ", hasRangeHeader=" + this.hasRangeHeader + "}";
    }
}

