/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.web.Body;
import com.renomad.minum.web.Headers;
import com.renomad.minum.web.IBodyProcessor;
import com.renomad.minum.web.IRequest;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.RequestLine;
import com.renomad.minum.web.StreamingMultipartPartition;
import com.renomad.minum.web.UrlEncodedKeyValue;
import com.renomad.minum.web.WebServerException;
import java.util.Objects;

public final class Request
implements IRequest {
    private final Headers headers;
    private final RequestLine requestLine;
    private Body body;
    private final String remoteRequester;
    private final ISocketWrapper socketWrapper;
    private final IBodyProcessor bodyProcessor;
    private boolean hasStartedReadingBody;

    public Request(Headers headers, RequestLine requestLine, String remoteRequester, ISocketWrapper socketWrapper, IBodyProcessor bodyProcessor) {
        this.headers = headers;
        this.requestLine = requestLine;
        this.remoteRequester = remoteRequester;
        this.socketWrapper = socketWrapper;
        this.bodyProcessor = bodyProcessor;
        this.hasStartedReadingBody = false;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    @Override
    public Body getBody() {
        if (this.hasStartedReadingBody) {
            throw new WebServerException("The InputStream in Request has already been accessed for reading, preventing body extraction from stream. If intending to use getBody(), use it exclusively");
        }
        if (this.body == null) {
            this.body = this.bodyProcessor.extractData(this.socketWrapper.getInputStream(), this.headers);
        }
        return this.body;
    }

    @Override
    public String getRemoteRequester() {
        return this.remoteRequester;
    }

    @Override
    public ISocketWrapper getSocketWrapper() {
        this.checkForExistingBody();
        this.hasStartedReadingBody = true;
        return this.socketWrapper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return this.hasStartedReadingBody == request.hasStartedReadingBody && Objects.equals(this.headers, request.headers) && Objects.equals(this.requestLine, request.requestLine) && Objects.equals(this.body, request.body) && Objects.equals(this.remoteRequester, request.remoteRequester) && Objects.equals(this.socketWrapper, request.socketWrapper) && Objects.equals(this.bodyProcessor, request.bodyProcessor);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.requestLine, this.body, this.remoteRequester, this.socketWrapper, this.bodyProcessor, this.hasStartedReadingBody);
    }

    public String toString() {
        return "Request{headers=" + String.valueOf(this.headers) + ", requestLine=" + String.valueOf(this.requestLine) + ", body=" + String.valueOf(this.body) + ", remoteRequester='" + this.remoteRequester + "', socketWrapper=" + String.valueOf(this.socketWrapper) + ", hasStartedReadingBody=" + this.hasStartedReadingBody + "}";
    }

    @Override
    public Iterable<UrlEncodedKeyValue> getUrlEncodedIterable() {
        this.checkForExistingBody();
        if (!this.headers.contentType().contains("application/x-www-form-urlencoded")) {
            throw new WebServerException("This request was not sent with a content type of application/x-www-form-urlencoded.  The content type was: " + this.headers.contentType());
        }
        return this.bodyProcessor.getUrlEncodedDataIterable(this.getSocketWrapper().getInputStream(), this.getHeaders().contentLength());
    }

    private void checkForExistingBody() {
        if (this.body != null) {
            throw new WebServerException("Requesting this after getting the body with getBody() will result in incorrect behavior.  If you intend to work with the Request at this level, do not use getBody");
        }
        if (this.hasStartedReadingBody) {
            throw new WebServerException("The InputStream has begun processing elsewhere.  Results are invalid.");
        }
    }

    @Override
    public Iterable<StreamingMultipartPartition> getMultipartIterable() {
        this.checkForExistingBody();
        if (!this.headers.contentType().contains("multipart/form-data")) {
            throw new WebServerException("This request was not sent with a content type of multipart/form-data.  The content type was: " + this.headers.contentType());
        }
        String boundaryKey = "boundary=";
        String contentType = this.getHeaders().contentType();
        int indexOfBoundaryKey = contentType.indexOf(boundaryKey);
        String boundaryValue = "";
        if (indexOfBoundaryKey <= 0) {
            String parsingError = "Did not find a valid boundary value for the multipart input. Returning an empty map and the raw bytes for the body. Header was: " + contentType;
            throw new WebServerException(parsingError);
        }
        boundaryValue = contentType.substring(indexOfBoundaryKey + boundaryKey.length());
        if (boundaryValue.isBlank()) {
            String parsingError = "Boundary value was blank. Returning an empty map and the raw bytes for the body. Header was: " + contentType;
            throw new WebServerException(parsingError);
        }
        return this.bodyProcessor.getMultiPartIterable(this.getSocketWrapper().getInputStream(), boundaryValue, this.getHeaders().contentLength());
    }
}

