/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.utils.Invariants;
import com.renomad.minum.utils.StringUtils;
import com.renomad.minum.web.HttpVersion;
import com.renomad.minum.web.PathDetails;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RequestLine {
    private final Method method;
    private final PathDetails pathDetails;
    private final HttpVersion version;
    private final String rawValue;
    private final ILogger logger;
    static final int MAX_QUERY_STRING_KEYS_COUNT = 50;
    static final String REQUEST_LINE_PATTERN = "^([A-Z]{3,8}) /?(.*) HTTP/(1.1|1.0)$";
    static final Pattern startLineRegex = Pattern.compile("^([A-Z]{3,8}) /?(.*) HTTP/(1.1|1.0)$");
    public static final RequestLine EMPTY = new RequestLine(Method.NONE, PathDetails.empty, HttpVersion.NONE, "", null);

    public RequestLine(Method method, PathDetails pathDetails, HttpVersion version, String rawValue, ILogger logger) {
        this.method = method;
        this.pathDetails = pathDetails;
        this.version = version;
        this.rawValue = rawValue;
        this.logger = logger;
    }

    public Map<String, String> queryString() {
        if (this.pathDetails == null || this.pathDetails.getQueryString().isEmpty()) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.pathDetails.getQueryString());
    }

    public RequestLine extractRequestLine(String value) {
        Invariants.mustNotBeNull(value);
        Matcher m = startLineRegex.matcher(value);
        boolean doesMatch = m.matches();
        if (!doesMatch) {
            return EMPTY;
        }
        Method myMethod = this.extractMethod(m.group(1));
        PathDetails pd = this.extractPathDetails(m.group(2));
        HttpVersion httpVersion = this.getHttpVersion(m.group(3));
        return new RequestLine(myMethod, pd, httpVersion, value, this.logger);
    }

    private Method extractMethod(String methodString) {
        try {
            return Method.valueOf(methodString.toUpperCase(Locale.ROOT));
        }
        catch (Exception ex) {
            this.logger.logDebug(() -> "Unable to convert method to enum: " + methodString);
            return Method.NONE;
        }
    }

    private PathDetails extractPathDetails(String path) {
        PathDetails pd;
        int locationOfQueryBegin = path.indexOf("?");
        if (locationOfQueryBegin > 0) {
            String rawQueryString = path.substring(locationOfQueryBegin + 1);
            String isolatedPath = path.substring(0, locationOfQueryBegin);
            Map<String, String> queryString = this.extractMapFromQueryString(rawQueryString);
            pd = new PathDetails(isolatedPath, rawQueryString, queryString);
        } else {
            pd = new PathDetails(path, null, null);
        }
        return pd;
    }

    Map<String, String> extractMapFromQueryString(String rawQueryString) {
        HashMap<String, String> queryStrings = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(rawQueryString, "&");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            if (i >= 50) {
                throw new ForbiddenUseException("User tried providing too many query string keys.  max: 50");
            }
            String currentKeyValue = tokenizer.nextToken();
            int equalSignLocation = currentKeyValue.indexOf("=");
            if (equalSignLocation <= 0) {
                return Map.of();
            }
            String key = currentKeyValue.substring(0, equalSignLocation);
            String value = StringUtils.decode(currentKeyValue.substring(equalSignLocation + 1));
            queryStrings.put(key, value);
            ++i;
        }
        return queryStrings;
    }

    private HttpVersion getHttpVersion(String version) {
        if (version.equals("1.1")) {
            return HttpVersion.ONE_DOT_ONE;
        }
        return HttpVersion.ONE_DOT_ZERO;
    }

    public Method getMethod() {
        return this.method;
    }

    public PathDetails getPathDetails() {
        return this.pathDetails;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestLine that = (RequestLine)o;
        return this.method == that.method && Objects.equals(this.pathDetails, that.pathDetails) && this.version == that.version && Objects.equals(this.rawValue, that.rawValue) && Objects.equals(this.logger, that.logger);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.pathDetails, this.version, this.rawValue, this.logger});
    }

    public String toString() {
        return "RequestLine{method=" + String.valueOf((Object)this.method) + ", pathDetails=" + String.valueOf(this.pathDetails) + ", version=" + String.valueOf((Object)this.version) + ", rawValue='" + this.rawValue + "', logger=" + String.valueOf(this.logger) + "}";
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        TRACE,
        PATCH,
        OPTIONS,
        HEAD,
        NONE;

    }
}

