/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.utils.FileUtils;
import com.renomad.minum.web.Headers;
import com.renomad.minum.web.IResponse;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.Range;
import com.renomad.minum.web.StatusLine;
import com.renomad.minum.web.ThrowingConsumer;
import com.renomad.minum.web.WebServerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public final class Response
implements IResponse {
    private final StatusLine.StatusCode statusCode;
    private final Map<String, String> extraHeaders;
    private final byte[] body;
    private final ThrowingConsumer<ISocketWrapper> outputGenerator;
    private final long bodyLength;

    Response(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders, byte[] body, ThrowingConsumer<ISocketWrapper> outputGenerator, long bodyLength) {
        this.statusCode = statusCode;
        this.extraHeaders = new HashMap<String, String>(extraHeaders);
        this.body = body;
        this.outputGenerator = outputGenerator;
        this.bodyLength = bodyLength;
    }

    public static IResponse buildStreamingResponse(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders, ThrowingConsumer<ISocketWrapper> outputGenerator) {
        return new Response(statusCode, extraHeaders, null, outputGenerator, 0L);
    }

    public static IResponse buildStreamingResponse(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders, ThrowingConsumer<ISocketWrapper> outputGenerator, long bodyLength) {
        return new Response(statusCode, extraHeaders, null, outputGenerator, bodyLength);
    }

    public static IResponse buildResponse(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders, byte[] body) {
        return new Response(statusCode, extraHeaders, body, socketWrapper -> Response.sendByteArrayResponse(socketWrapper, body), body.length);
    }

    public static IResponse buildResponse(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders, String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        return new Response(statusCode, extraHeaders, bytes, socketWrapper -> Response.sendByteArrayResponse(socketWrapper, bytes), bytes.length);
    }

    public static IResponse buildLargeFileResponse(Map<String, String> extraHeaders, String filePath, Headers requestHeaders) throws IOException {
        HashMap<String, String> adjustedHeaders = new HashMap<String, String>(extraHeaders);
        long fileSize = Files.size(Path.of(filePath, new String[0]));
        Range range = new Range(requestHeaders, fileSize);
        StatusLine.StatusCode responseCode = StatusLine.StatusCode.CODE_200_OK;
        long length = fileSize;
        if (range.hasRangeHeader()) {
            long offset = range.getOffset();
            length = range.getLength();
            long lastIndex = offset + length - 1L;
            adjustedHeaders.put("Content-Range", String.format("bytes %d-%d/%d", offset, lastIndex, fileSize));
            responseCode = StatusLine.StatusCode.CODE_206_PARTIAL_CONTENT;
        }
        ThrowingConsumer<ISocketWrapper> outputGenerator = socketWrapper -> {
            try (RandomAccessFile reader = new RandomAccessFile(filePath, "r");){
                reader.seek(range.getOffset());
                FileChannel fileChannel = reader.getChannel();
                Response.sendFileChannelResponse(socketWrapper, fileChannel, range.getLength());
            }
        };
        return new Response(responseCode, adjustedHeaders, null, outputGenerator, length);
    }

    public static IResponse buildLargeFileResponse(Map<String, String> extraHeaders, String filePath, String parentDirectory, Headers requestHeaders) throws IOException {
        Path path = FileUtils.safeResolve(parentDirectory, filePath);
        return Response.buildLargeFileResponse(extraHeaders, path.toString(), requestHeaders);
    }

    public static IResponse buildLeanResponse(StatusLine.StatusCode statusCode, Map<String, String> extraHeaders) {
        return new Response(statusCode, extraHeaders, null, socketWrapper -> {}, 0L);
    }

    public static IResponse buildLeanResponse(StatusLine.StatusCode statusCode) {
        return new Response(statusCode, Map.of(), null, socketWrapper -> {}, 0L);
    }

    public static IResponse redirectTo(String locationUrl) {
        try {
            URI.create(locationUrl);
        }
        catch (Exception ex) {
            throw new WebServerException("Failure in redirect to (" + locationUrl + "). Exception: " + String.valueOf(ex));
        }
        return Response.buildResponse(StatusLine.StatusCode.CODE_303_SEE_OTHER, Map.of("location", locationUrl, "Content-Type", "text/html; charset=UTF-8"), "<p>See <a href=\"" + locationUrl + "\">this link</a></p>");
    }

    public static IResponse htmlOk(String body, Map<String, String> extraHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/html; charset=UTF-8");
        headers.putAll(extraHeaders);
        return Response.buildResponse(StatusLine.StatusCode.CODE_200_OK, headers, body);
    }

    public static IResponse htmlOk(String body) {
        return Response.htmlOk(body, Map.of());
    }

    @Override
    public Map<String, String> getExtraHeaders() {
        return new HashMap<String, String>(this.extraHeaders);
    }

    @Override
    public StatusLine.StatusCode getStatusCode() {
        return this.statusCode;
    }

    long getBodyLength() {
        if (this.body != null) {
            return this.body.length;
        }
        return this.bodyLength;
    }

    void sendBody(ISocketWrapper sw) throws IOException {
        try {
            this.outputGenerator.accept(sw);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendFileChannelResponse(ISocketWrapper sw, FileChannel fileChannel, long length) throws IOException {
        try {
            int countBytesRead;
            int bufferSize = 8192;
            ByteBuffer buff = ByteBuffer.allocate(bufferSize);
            long countBytesLeftToSend = length;
            while ((countBytesRead = fileChannel.read(buff)) > 0) {
                if (countBytesLeftToSend < (long)countBytesRead) {
                    sw.send(buff.array(), 0, (int)countBytesLeftToSend);
                    break;
                }
                sw.send(buff.array(), 0, countBytesRead);
                buff.clear();
                countBytesLeftToSend -= (long)countBytesRead;
            }
        }
        finally {
            fileChannel.close();
        }
    }

    private static void sendByteArrayResponse(ISocketWrapper sw, byte[] body) throws IOException {
        sw.send(body);
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    Response compressBody() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(out);
        gos.write(this.body);
        gos.finish();
        return (Response)Response.buildResponse(this.statusCode, this.extraHeaders, out.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return this.bodyLength == response.bodyLength && this.statusCode == response.statusCode && Objects.equals(this.extraHeaders, response.extraHeaders) && Arrays.equals(this.body, response.body);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.statusCode, this.extraHeaders, this.bodyLength});
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    public String toString() {
        return "Response{statusCode=" + String.valueOf((Object)this.statusCode) + ", extraHeaders=" + String.valueOf(this.extraHeaders) + ", bodyLength=" + this.bodyLength + "}";
    }
}

