/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.security.ITheBrig;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.ConcurrentSet;
import com.renomad.minum.utils.StacktraceUtils;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.web.HttpServerType;
import com.renomad.minum.web.IServer;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.SetOfSws;
import com.renomad.minum.web.SocketWrapper;
import com.renomad.minum.web.WebFramework;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class Server
implements IServer {
    private final ServerSocket serverSocket;
    private final SetOfSws setOfSWs;
    private final ExecutorService es;
    private final HttpServerType serverType;
    private final ILogger logger;
    private final String serverName;
    private final ITheBrig theBrig;
    private final Constants constants;
    private final WebFramework webFramework;
    private Future<?> centralLoopFuture;

    Server(ServerSocket ss, Context context, String serverName, ITheBrig theBrig, WebFramework webFramework, ExecutorService es, HttpServerType serverType) {
        this.serverSocket = ss;
        this.logger = context.getLogger();
        this.constants = context.getConstants();
        this.webFramework = webFramework;
        this.serverName = serverName;
        this.theBrig = theBrig;
        this.setOfSWs = new SetOfSws(new ConcurrentSet<ISocketWrapper>(), this.logger, serverName);
        this.es = es;
        this.serverType = serverType;
    }

    @Override
    public void start() {
        ThrowingRunnable serverCode = this.buildMainServerLoop(this.es);
        Runnable t = ThrowingRunnable.throwingRunnableWrapper(serverCode, this.logger);
        this.centralLoopFuture = this.es.submit(t);
    }

    private ThrowingRunnable buildMainServerLoop(ExecutorService es) {
        return () -> {
            Thread.currentThread().setName("Main Server");
            try {
                while (true) {
                    this.logger.logTrace(() -> this.serverName + " waiting to accept connection");
                    Socket freshSocket = this.serverSocket.accept();
                    SocketWrapper sw = new SocketWrapper(freshSocket, this, this.logger, this.constants.socketTimeoutMillis, this.constants.hostName);
                    this.logger.logTrace(() -> String.format("client connected from %s", sw.getRemoteAddrWithPort()));
                    this.setOfSWs.add(sw);
                    ThrowingRunnable innerServerCode = this.webFramework.makePrimaryHttpHandler(sw, this.theBrig);
                    Runnable task = ThrowingRunnable.throwingRunnableWrapper(innerServerCode, this.logger);
                    es.submit(task);
                }
            }
            catch (IOException ex) {
                Server.handleServerException(ex, this.logger);
                return;
            }
        };
    }

    static void handleServerException(IOException ex, ILogger logger) {
        if (!ex.getMessage().contains("Socket closed") && !ex.getMessage().contains("Socket is closed")) {
            logger.logAsyncError(() -> StacktraceUtils.stackTraceToString(ex));
        }
    }

    @Override
    public void close() throws IOException {
        this.setOfSWs.stopAllServers();
        this.logger.logTrace(() -> "close called on " + String.valueOf(this));
        this.serverSocket.close();
    }

    @Override
    public String getHost() {
        return this.serverSocket.getInetAddress().getHostAddress();
    }

    @Override
    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void removeMyRecord(ISocketWrapper socketWrapper) {
        this.setOfSWs.remove(socketWrapper);
    }

    public String toString() {
        return this.serverName;
    }

    @Override
    public Future<?> getCentralLoopFuture() {
        return this.centralLoopFuture;
    }

    @Override
    public HttpServerType getServerType() {
        return this.serverType;
    }
}

