/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.web.HttpServerType;
import com.renomad.minum.web.IServer;
import com.renomad.minum.web.ISocketWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;

final class SocketWrapper
implements ISocketWrapper {
    private final Socket socket;
    private final String hostName;
    private final InputStream inputStream;
    private final OutputStream writer;
    private final ILogger logger;
    private final IServer server;

    SocketWrapper(Socket socket, IServer server, ILogger logger, int timeoutMillis, String hostName) throws IOException {
        this.socket = socket;
        this.hostName = hostName;
        logger.logTrace(() -> String.format("Setting timeout of %d milliseconds on socket %s", timeoutMillis, socket));
        this.socket.setSoTimeout(timeoutMillis);
        this.inputStream = socket.getInputStream();
        this.writer = socket.getOutputStream();
        this.logger = logger;
        this.server = server;
    }

    @Override
    public void send(String msg) throws IOException {
        this.writer.write(msg.getBytes(Charset.defaultCharset()));
    }

    @Override
    public void send(byte[] bodyContents) throws IOException {
        this.writer.write(bodyContents);
    }

    @Override
    public void send(byte[] bodyContents, int off, int len) throws IOException {
        this.writer.write(bodyContents, off, len);
    }

    @Override
    public void send(int b) throws IOException {
        this.writer.write(b);
    }

    @Override
    public void sendHttpLine(String msg) throws IOException {
        this.logger.logTrace(() -> String.format("%s sending: \"%s\"", this, msg));
        this.send(msg + "\r\n");
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteAddrWithPort() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public HttpServerType getServerType() {
        return this.server.getServerType();
    }

    @Override
    public void close() throws IOException {
        this.logger.logTrace(() -> "close called on " + String.valueOf(this));
        this.socket.close();
        if (this.server != null) {
            this.server.removeMyRecord(this);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String toString() {
        return "(SocketWrapper for remote address: " + this.getRemoteAddrWithPort().toString() + ")";
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }
}

