/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.utils.RingBuffer;
import com.renomad.minum.web.ContentDisposition;
import com.renomad.minum.web.CountBytesRead;
import com.renomad.minum.web.Headers;
import com.renomad.minum.web.WebServerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.IntStream;

public class StreamingMultipartPartition
extends InputStream {
    private final Headers headers;
    private final InputStream inputStream;
    private final ContentDisposition contentDisposition;
    private final int contentLength;
    private boolean isFinished = false;
    private final RingBuffer<Byte> recentBytesBuffer;
    private final CountBytesRead countBytesRead;
    private final List<Byte> boundaryValueList;
    private boolean hasFilledBuffer;

    StreamingMultipartPartition(Headers headers, InputStream inputStream, ContentDisposition contentDisposition, String boundaryValue, CountBytesRead countBytesRead, int contentLength) {
        this.headers = headers;
        this.inputStream = inputStream;
        this.contentDisposition = contentDisposition;
        this.contentLength = contentLength;
        String boundaryValue1 = "\r\n--" + boundaryValue;
        byte[] bytes = boundaryValue1.getBytes(StandardCharsets.US_ASCII);
        this.boundaryValueList = IntStream.range(0, bytes.length).mapToObj(i -> bytes[i]).toList();
        this.recentBytesBuffer = new RingBuffer<Byte>(boundaryValue1.length(), Byte.class);
        this.countBytesRead = countBytesRead;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public int read() throws IOException {
        if (this.isFinished) {
            return -1;
        }
        if (!this.hasFilledBuffer) {
            this.fillBuffer();
            boolean atTheEnd = this.recentBytesBuffer.containsAt(this.boundaryValueList, 0);
            if (atTheEnd) {
                byte[] unused = this.inputStream.readNBytes(2);
                this.isFinished = true;
                return -1;
            }
        } else {
            int result = this.inputStream.read();
            this.countBytesRead.increment();
            if (this.countBytesRead.getCount() >= this.contentLength) {
                this.isFinished = true;
                return -1;
            }
            if (result == -1) {
                throw new IOException("Error: The inputstream has closed unexpectedly while reading");
            }
            byte byteValue = (byte)result;
            boolean isAtEndOfPartition = this.updateRecentBytesBufferAndCheck(byteValue);
            if (isAtEndOfPartition) {
                byte[] unused = this.inputStream.readNBytes(2);
                this.isFinished = true;
                return -1;
            }
        }
        return this.recentBytesBuffer.atNextIndex() & 0xFF;
    }

    private void fillBuffer() throws IOException {
        for (int i = 0; i < this.recentBytesBuffer.getLimit(); ++i) {
            int result = this.inputStream.read();
            this.countBytesRead.increment();
            if (result == -1) {
                throw new IOException("Error: The inputstream has closed unexpectedly while reading");
            }
            byte byteValue = (byte)result;
            this.updateRecentBytesBufferAndCheck(byteValue);
        }
        this.hasFilledBuffer = true;
    }

    @Override
    public byte[] readAllBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            int result = 0;
            try {
                result = this.read();
            }
            catch (IOException e) {
                throw new WebServerException(e);
            }
            if (result == -1) {
                return baos.toByteArray();
            }
            baos.write((byte)result);
        }
    }

    private boolean updateRecentBytesBufferAndCheck(byte newByte) {
        this.recentBytesBuffer.add(newByte);
        return this.recentBytesBuffer.containsAt(this.boundaryValueList, 0);
    }

    @Override
    public void close() throws IOException {
        int result;
        while ((result = this.read()) != -1) {
        }
    }
}

