/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.web.CountBytesRead;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UrlEncodedDataGetter
extends InputStream {
    private final InputStream inputStream;
    private final CountBytesRead countBytesRead;
    private final long contentLength;
    private boolean isFinished = false;

    UrlEncodedDataGetter(InputStream inputStream, CountBytesRead countBytesRead, long contentLength) {
        this.inputStream = inputStream;
        this.countBytesRead = countBytesRead;
        this.contentLength = contentLength;
    }

    @Override
    public int read() throws IOException {
        if (this.isFinished) {
            return -1;
        }
        if ((long)this.countBytesRead.getCount() == this.contentLength) {
            this.isFinished = true;
            return -1;
        }
        int result = this.inputStream.read();
        if (result == -1) {
            this.isFinished = true;
            throw new IOException("Error: The inputstream has closed unexpectedly while reading");
        }
        this.countBytesRead.increment();
        char byteValue = (char)result;
        if (byteValue == '&') {
            this.isFinished = true;
            return -1;
        }
        return result;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int result;
        while ((result = this.read()) != -1) {
            baos.write((byte)result);
        }
        return baos.toByteArray();
    }

    @Override
    public void close() throws IOException {
        int result;
        while ((result = this.read()) != -1) {
        }
    }
}

