/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.security.ITheBrig;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.web.HttpServerType;
import com.renomad.minum.web.IServer;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.Server;
import com.renomad.minum.web.SocketWrapper;
import com.renomad.minum.web.WebFramework;
import com.renomad.minum.web.WebServerException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

final class WebEngine {
    private final ITheBrig theBrig;
    private final Constants constants;
    private final Context context;
    private final ExecutorService executorService;
    private final WebFramework webFramework;
    private final ILogger logger;
    static final String HTTP_CRLF = "\r\n";

    WebEngine(Context context, WebFramework webFramework) {
        this.logger = context.getLogger();
        this.logger.logDebug(() -> "Using a supplied logger in WebEngine");
        this.theBrig = context.getFullSystem() != null ? context.getFullSystem().getTheBrig() : null;
        this.constants = context.getConstants();
        this.context = context;
        this.executorService = context.getExecutorService();
        this.webFramework = webFramework;
    }

    IServer startServer() {
        ServerSocket ss;
        int port = this.constants.serverPort;
        try {
            ss = new ServerSocket(port);
        }
        catch (Exception e) {
            throw new WebServerException(e);
        }
        this.logger.logDebug(() -> String.format("Just created a new ServerSocket: %s", ss));
        Server server = new Server(ss, this.context, "http server", this.theBrig, this.webFramework, this.executorService, HttpServerType.PLAIN_TEXT_HTTP);
        this.logger.logDebug(() -> String.format("Just created a new Server: %s", server));
        server.start();
        String hostname = this.constants.hostName;
        this.logger.logDebug(() -> String.format("%s started at http://%s:%s", server, hostname, port));
        return server;
    }

    IServer startSslServer() {
        Boolean useExternalKeystore = WebEngine.isProvidedKeystoreProperties(this.constants.keystorePath, this.constants.keystorePassword, this.logger);
        KeyStoreResult keystoreResult = WebEngine.getKeyStoreResult(useExternalKeystore, this.constants.keystorePath, this.constants.keystorePassword, this.logger);
        int port = this.constants.secureServerPort;
        ServerSocket ss = this.createSslSocketWithSpecificKeystore(port, keystoreResult.keystoreUrl(), keystoreResult.keystorePassword());
        this.logger.logDebug(() -> String.format("Just created a new ServerSocket: %s", ss));
        Server server = new Server(ss, this.context, "https server", this.theBrig, this.webFramework, this.executorService, HttpServerType.ENCRYPTED_HTTP);
        this.logger.logDebug(() -> String.format("Just created a new SSL Server: %s", server));
        server.start();
        String hostname = this.constants.hostName;
        this.logger.logDebug(() -> String.format("%s started at https://%s:%s", server, hostname, port));
        return server;
    }

    static KeyStoreResult getKeyStoreResult(boolean useExternalKeystore, String keystorePath, String keystorePassword, ILogger logger) {
        URL keystoreUrl;
        if (useExternalKeystore) {
            logger.logDebug(() -> "Using keystore and password referenced in minum.config");
        } else {
            logger.logDebug(() -> "Using the default (self-signed / testing-only) certificate");
        }
        try {
            keystoreUrl = useExternalKeystore ? Path.of(keystorePath, new String[0]).toUri().toURL() : WebEngine.class.getResource("/certs/keystore");
        }
        catch (Exception e) {
            throw new WebServerException("Error while building keystoreUrl: " + String.valueOf(e));
        }
        String keystorePasswordFinal = useExternalKeystore ? keystorePassword : "passphrase";
        return new KeyStoreResult(keystoreUrl, keystorePasswordFinal);
    }

    static Boolean isProvidedKeystoreProperties(String keystorePath, String keystorePassword, ILogger logger) {
        boolean hasKeystorePassword;
        boolean hasKeystore;
        boolean bl = hasKeystore = keystorePath != null && !keystorePath.isBlank();
        if (!hasKeystore) {
            logger.logDebug(() -> "Keystore system property was not set");
        }
        boolean bl2 = hasKeystorePassword = keystorePassword != null && !keystorePassword.isBlank();
        if (!hasKeystorePassword) {
            logger.logDebug(() -> "keystorePassword system property was not set");
        }
        return hasKeystore && hasKeystorePassword;
    }

    ServerSocket createSslSocketWithSpecificKeystore(int sslPort, URL keystoreUrl, String keystorePassword) {
        ServerSocket serverSocket;
        block8: {
            InputStream keystoreInputStream = keystoreUrl.openStream();
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] passwordCharArray = keystorePassword.toCharArray();
                keyStore.load(keystoreInputStream, passwordCharArray);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, passwordCharArray);
                KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
                sslContext.init(keyManagers, null, new SecureRandom());
                SSLServerSocketFactory socketFactory = sslContext.getServerSocketFactory();
                serverSocket = socketFactory.createServerSocket(sslPort);
                if (keystoreInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keystoreInputStream != null) {
                        try {
                            keystoreInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.logger.logDebug(ex::getMessage);
                    throw new WebServerException(ex);
                }
            }
            keystoreInputStream.close();
        }
        return serverSocket;
    }

    ISocketWrapper startClient(Socket socket) throws IOException {
        this.logger.logDebug(() -> String.format("Just created new client socket: %s", socket));
        return new SocketWrapper(socket, null, this.logger, this.constants.socketTimeoutMillis, this.constants.hostName);
    }

    public String toString() {
        return super.toString();
    }

    record KeyStoreResult(URL keystoreUrl, String keystorePassword) {
    }
}

