/*
 * Decompiled with CFR 0.152.
 */
package com.renomad.minum.web;

import com.renomad.minum.logging.ILogger;
import com.renomad.minum.security.ForbiddenUseException;
import com.renomad.minum.security.ITheBrig;
import com.renomad.minum.security.UnderInvestigation;
import com.renomad.minum.state.Constants;
import com.renomad.minum.state.Context;
import com.renomad.minum.utils.FileReader;
import com.renomad.minum.utils.FileUtils;
import com.renomad.minum.utils.IFileReader;
import com.renomad.minum.utils.Invariants;
import com.renomad.minum.utils.LRUCache;
import com.renomad.minum.utils.SearchUtils;
import com.renomad.minum.utils.StacktraceUtils;
import com.renomad.minum.utils.ThrowingRunnable;
import com.renomad.minum.web.BodyProcessor;
import com.renomad.minum.web.FullSystem;
import com.renomad.minum.web.Headers;
import com.renomad.minum.web.HttpVersion;
import com.renomad.minum.web.IBodyProcessor;
import com.renomad.minum.web.IInputStreamUtils;
import com.renomad.minum.web.IRequest;
import com.renomad.minum.web.IResponse;
import com.renomad.minum.web.ISocketWrapper;
import com.renomad.minum.web.InputStreamUtils;
import com.renomad.minum.web.LastMinuteHandlerInputs;
import com.renomad.minum.web.PathDetails;
import com.renomad.minum.web.PreHandlerInputs;
import com.renomad.minum.web.Request;
import com.renomad.minum.web.RequestLine;
import com.renomad.minum.web.Response;
import com.renomad.minum.web.StatusLine;
import com.renomad.minum.web.ThrowingFunction;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;

public final class WebFramework {
    private final Constants constants;
    private final UnderInvestigation underInvestigation;
    private final IInputStreamUtils inputStreamUtils;
    private final IBodyProcessor bodyProcessor;
    private final Random randomErrorCorrelationId;
    private final RequestLine emptyRequestLine;
    private final Map<MethodPath, ThrowingFunction<IRequest, IResponse>> registeredDynamicPaths;
    private final Map<MethodPath, ThrowingFunction<IRequest, IResponse>> registeredPartialPaths;
    private ThrowingFunction<PreHandlerInputs, IResponse> preHandler;
    private ThrowingFunction<LastMinuteHandlerInputs, IResponse> lastMinuteHandler;
    private final IFileReader fileReader;
    private final Map<String, String> fileSuffixToMime;
    private final ZonedDateTime overrideForDateTime;
    private final FullSystem fs;
    private final ILogger logger;
    private static final int MINIMUM_NUMBER_OF_BYTES_TO_COMPRESS = 2048;

    public Map<String, String> getSuffixToMimeMappings() {
        return new HashMap<String, String>(this.fileSuffixToMime);
    }

    ThrowingRunnable makePrimaryHttpHandler(ISocketWrapper sw, ITheBrig theBrig) {
        return () -> {
            Thread.currentThread().setName("SocketWrapper thread for " + sw.getRemoteAddr());
            try (ISocketWrapper iSocketWrapper = sw;){
                boolean isKeepAlive;
                this.dumpIfAttacker(sw, this.fs);
                InputStream is = sw.getInputStream();
                do {
                    String rawStartLine = this.inputStreamUtils.readLine(is);
                    long startMillis = System.currentTimeMillis();
                    if (rawStartLine.isEmpty()) {
                        this.logger.logTrace(() -> "rawStartLine was empty.  Returning.");
                        break;
                    }
                    RequestLine sl = this.getProcessedRequestLine(sw, rawStartLine);
                    if (sl.equals(this.emptyRequestLine)) {
                        this.logger.logTrace(() -> "RequestLine was unparseable.  Returning.");
                        break;
                    }
                    this.checkIfSuspiciousPath(sw, sl);
                    Headers hi = this.getHeaders(sw);
                    isKeepAlive = WebFramework.determineIfKeepAlive(sl, hi, this.logger);
                    if (WebFramework.isThereIsABody(hi)) {
                        this.logger.logTrace(() -> "There is a body. Content-type is " + hi.contentType());
                    }
                    ProcessingResult result = this.processRequest(sw, sl, hi);
                    IRequest request = result.clientRequest();
                    Response response = (Response)result.resultingResponse();
                    StringBuilder headerStringBuilder = this.addDefaultHeaders(response);
                    WebFramework.addOptionalExtraHeaders(response, headerStringBuilder);
                    this.addKeepAliveTimeout(isKeepAlive, headerStringBuilder);
                    Response adjustedResponse = WebFramework.potentiallyCompress(request.getHeaders(), response, headerStringBuilder);
                    WebFramework.applyContentLength(headerStringBuilder, adjustedResponse.getBodyLength());
                    WebFramework.confirmBodyHasContentType(request, response);
                    sw.send(headerStringBuilder.append("\r\n").toString());
                    if (request.getRequestLine().getMethod().equals((Object)RequestLine.Method.HEAD)) {
                        this.logger.logDebug(() -> "client " + request.getRemoteRequester() + " is requesting HEAD for " + request.getRequestLine().getPathDetails().getIsolatedPath() + ".  Excluding body from response");
                    } else {
                        adjustedResponse.sendBody(sw);
                    }
                    long endMillis = System.currentTimeMillis();
                    this.logger.logTrace(() -> String.format("full processing (including communication time) of %s %s took %d millis", sw, sl, endMillis - startMillis));
                } while (isKeepAlive);
            }
            catch (SocketException | SocketTimeoutException ex) {
                WebFramework.handleReadTimedOut(sw, ex, this.logger);
            }
            catch (ForbiddenUseException ex) {
                WebFramework.handleForbiddenUse(sw, ex, this.logger, theBrig, this.constants.vulnSeekingJailDuration);
            }
            catch (IOException ex) {
                WebFramework.handleIOException(sw, ex, this.logger, theBrig, this.underInvestigation, this.constants.vulnSeekingJailDuration);
            }
        };
    }

    static void handleIOException(ISocketWrapper sw, IOException ex, ILogger logger, ITheBrig theBrig, UnderInvestigation underInvestigation, int vulnSeekingJailDuration) {
        logger.logDebug(() -> ex.getMessage() + " (at Server.start)");
        String suspiciousClues = underInvestigation.isClientLookingForVulnerabilities(ex.getMessage());
        if (!suspiciousClues.isEmpty() && theBrig != null) {
            logger.logDebug(() -> sw.getRemoteAddr() + " is looking for vulnerabilities, for this: " + suspiciousClues);
            theBrig.sendToJail(sw.getRemoteAddr() + "_vuln_seeking", vulnSeekingJailDuration);
        }
    }

    static void handleForbiddenUse(ISocketWrapper sw, ForbiddenUseException ex, ILogger logger, ITheBrig theBrig, int vulnSeekingJailDuration) {
        logger.logDebug(() -> sw.getRemoteAddr() + " is looking for vulnerabilities, for this: " + ex.getMessage());
        if (theBrig != null) {
            theBrig.sendToJail(sw.getRemoteAddr() + "_vuln_seeking", vulnSeekingJailDuration);
        } else {
            logger.logDebug(() -> "theBrig is null at handleForbiddenUse, will not store address in database");
        }
    }

    static void handleReadTimedOut(ISocketWrapper sw, IOException ex, ILogger logger) {
        if (ex.getMessage().equals("Read timed out")) {
            logger.logTrace(() -> "Read timed out - remote address: " + String.valueOf(sw.getRemoteAddrWithPort()));
        } else {
            logger.logDebug(() -> ex.getMessage() + " - remote address: " + String.valueOf(sw.getRemoteAddrWithPort()));
        }
    }

    ProcessingResult processRequest(ISocketWrapper sw, RequestLine requestLine, Headers requestHeaders) throws Exception {
        IResponse response;
        Request clientRequest = new Request(requestHeaders, requestLine, sw.getRemoteAddr(), sw, this.bodyProcessor);
        ThrowingFunction<IRequest, IResponse> endpoint = this.findEndpointForThisStartline(requestLine, requestHeaders);
        if (endpoint == null) {
            response = Response.buildLeanResponse(StatusLine.StatusCode.CODE_404_NOT_FOUND);
        } else {
            long millisAtStart = System.currentTimeMillis();
            try {
                response = this.preHandler != null ? this.preHandler.apply(new PreHandlerInputs(clientRequest, endpoint, sw)) : endpoint.apply(clientRequest);
            }
            catch (Exception ex) {
                int randomNumber = this.randomErrorCorrelationId.nextInt();
                this.logger.logAsyncError(() -> "error while running endpoint " + String.valueOf(endpoint) + ". Code: " + randomNumber + ". Error: " + StacktraceUtils.stackTraceToString(ex));
                response = Response.buildResponse(StatusLine.StatusCode.CODE_500_INTERNAL_SERVER_ERROR, Map.of("Content-Type", "text/plain;charset=UTF-8"), "Server error: " + randomNumber);
            }
            long millisAtEnd = System.currentTimeMillis();
            this.logger.logTrace(() -> String.format("handler processing of %s %s took %d millis", sw, requestLine, millisAtEnd - millisAtStart));
        }
        if (this.lastMinuteHandler != null) {
            response = this.lastMinuteHandler.apply(new LastMinuteHandlerInputs(clientRequest, response));
        }
        return new ProcessingResult(clientRequest, response);
    }

    private Headers getHeaders(ISocketWrapper sw) {
        List<String> allHeaders = Headers.getAllHeaders(sw.getInputStream(), this.inputStreamUtils);
        Headers hi = new Headers(allHeaders);
        this.logger.logTrace(() -> "The headers are: " + String.valueOf(hi.getHeaderStrings()));
        return hi;
    }

    static boolean determineIfKeepAlive(RequestLine sl, Headers hi, ILogger logger) {
        boolean isKeepAlive = false;
        if (sl.getVersion() == HttpVersion.ONE_DOT_ZERO) {
            isKeepAlive = hi.hasKeepAlive();
        } else if (sl.getVersion() == HttpVersion.ONE_DOT_ONE) {
            isKeepAlive = !hi.hasConnectionClose();
        }
        boolean finalIsKeepAlive = isKeepAlive;
        logger.logTrace(() -> "Is this a keep-alive connection? " + finalIsKeepAlive);
        return isKeepAlive;
    }

    RequestLine getProcessedRequestLine(ISocketWrapper sw, String rawStartLine) {
        this.logger.logTrace(() -> String.valueOf(sw) + ": raw request line received: " + rawStartLine);
        RequestLine rl = new RequestLine(RequestLine.Method.NONE, PathDetails.empty, HttpVersion.NONE, "", this.logger);
        RequestLine extractedRequestLine = rl.extractRequestLine(rawStartLine);
        this.logger.logTrace(() -> String.valueOf(sw) + ": RequestLine has been derived: " + String.valueOf(extractedRequestLine));
        return extractedRequestLine;
    }

    void checkIfSuspiciousPath(ISocketWrapper sw, RequestLine requestLine) {
        String suspiciousClues = this.underInvestigation.isLookingForSuspiciousPaths(requestLine.getPathDetails().getIsolatedPath());
        if (!suspiciousClues.isEmpty()) {
            String msg = sw.getRemoteAddr() + " is looking for a vulnerability, for this: " + suspiciousClues;
            throw new ForbiddenUseException(msg);
        }
    }

    boolean dumpIfAttacker(ISocketWrapper sw, FullSystem fs) {
        if (fs == null) {
            return false;
        }
        if (fs.getTheBrig() == null) {
            return false;
        }
        this.dumpIfAttacker(sw, fs.getTheBrig());
        return true;
    }

    void dumpIfAttacker(ISocketWrapper sw, ITheBrig theBrig) {
        String remoteClient = sw.getRemoteAddr();
        if (theBrig.isInJail(remoteClient + "_vuln_seeking")) {
            String message = "closing the socket on " + remoteClient + " due to being found in the brig";
            this.logger.logDebug(() -> message);
            throw new ForbiddenUseException(message);
        }
    }

    static boolean isThereIsABody(Headers hi) {
        if (!hi.contentType().isBlank()) {
            if (hi.contentLength() > 0) {
                return true;
            }
            List<String> transferEncodingHeaders = hi.valueByKey("transfer-encoding");
            return transferEncodingHeaders != null && transferEncodingHeaders.stream().anyMatch(x -> x.equalsIgnoreCase("chunked"));
        }
        return false;
    }

    private StringBuilder addDefaultHeaders(IResponse response) {
        String date = Objects.requireNonNullElseGet(this.overrideForDateTime, () -> ZonedDateTime.now(ZoneId.of("UTC"))).format(DateTimeFormatter.RFC_1123_DATE_TIME);
        StringBuilder headerStringBuilder = new StringBuilder();
        headerStringBuilder.append("HTTP/1.1 ").append(response.getStatusCode().code).append(" ").append(response.getStatusCode().shortDescription).append("\r\n");
        headerStringBuilder.append("Date: ").append(date).append("\r\n");
        headerStringBuilder.append("Server: minum").append("\r\n");
        return headerStringBuilder;
    }

    private static void addOptionalExtraHeaders(IResponse response, StringBuilder stringBuilder) {
        stringBuilder.append(response.getExtraHeaders().entrySet().stream().map(x -> (String)x.getKey() + ": " + (String)x.getValue() + "\r\n").collect(Collectors.joining()));
    }

    static void confirmBodyHasContentType(IRequest request, Response response) {
        boolean hasContentType = response.getExtraHeaders().entrySet().stream().anyMatch(x -> ((String)x.getKey()).toLowerCase(Locale.ROOT).equals("content-type"));
        if (response.getBodyLength() > 0L) {
            Invariants.mustBeTrue(hasContentType, "a Content-Type header must be specified in the Response object if it returns data. Response details: " + String.valueOf(response) + " Request: " + String.valueOf(request));
        }
    }

    private void addKeepAliveTimeout(boolean isKeepAlive, StringBuilder stringBuilder) {
        if (isKeepAlive) {
            stringBuilder.append("Keep-Alive: timeout=").append(this.constants.keepAliveTimeoutSeconds).append("\r\n");
        }
    }

    private static void applyContentLength(StringBuilder stringBuilder, long bodyLength) {
        stringBuilder.append("Content-Length: ").append(bodyLength).append("\r\n");
    }

    static Response potentiallyCompress(Headers headers, Response response, StringBuilder headerStringBuilder) throws IOException {
        String contentType;
        List<String> acceptEncoding = headers.valueByKey("accept-encoding");
        Map.Entry contentTypeHeader = SearchUtils.findExactlyOne(response.getExtraHeaders().entrySet().stream(), x -> ((String)x.getKey()).equalsIgnoreCase("content-type"));
        if (contentTypeHeader != null && (contentType = ((String)contentTypeHeader.getValue()).toLowerCase(Locale.ROOT)).contains("text/")) {
            return WebFramework.compressBodyIfRequested(response, acceptEncoding, headerStringBuilder, 2048);
        }
        return response;
    }

    static Response compressBodyIfRequested(Response response, List<String> acceptEncoding, StringBuilder stringBuilder, int minNumberBytes) throws IOException {
        String allContentEncodingHeaders;
        String string = allContentEncodingHeaders = acceptEncoding != null ? String.join((CharSequence)";", acceptEncoding) : "";
        if (response.getBodyLength() >= (long)minNumberBytes && acceptEncoding != null && allContentEncodingHeaders.contains("gzip")) {
            stringBuilder.append("Content-Encoding: gzip\r\n");
            stringBuilder.append("Vary: accept-encoding\r\n");
            return response.compressBody();
        }
        return response;
    }

    ThrowingFunction<IRequest, IResponse> findEndpointForThisStartline(RequestLine sl, Headers requestHeaders) {
        this.logger.logTrace(() -> "Seeking a handler for " + String.valueOf(sl));
        String requestedPath = sl.getPathDetails().getIsolatedPath().toLowerCase(Locale.ROOT);
        RequestLine.Method method = sl.getMethod() == RequestLine.Method.HEAD ? RequestLine.Method.GET : sl.getMethod();
        MethodPath key = new MethodPath(method, requestedPath);
        ThrowingFunction<IRequest, IResponse> handler = this.registeredDynamicPaths.get(key);
        if (handler == null) {
            this.logger.logTrace(() -> "No direct handler found.  looking for a partial match for " + requestedPath);
            handler = this.findHandlerByPartialMatch(sl);
        }
        if (handler == null) {
            this.logger.logTrace(() -> "No partial match found, checking files on disk for " + requestedPath);
            handler = this.findHandlerByFilesOnDisk(sl, requestHeaders);
        }
        return handler;
    }

    private ThrowingFunction<IRequest, IResponse> findHandlerByFilesOnDisk(RequestLine sl, Headers requestHeaders) {
        if (sl.getMethod() != RequestLine.Method.GET && sl.getMethod() != RequestLine.Method.HEAD) {
            return null;
        }
        String requestedPath = sl.getPathDetails().getIsolatedPath();
        IResponse response = this.readStaticFile(requestedPath, requestHeaders);
        return request -> response;
    }

    IResponse readStaticFile(String path, Headers requestHeaders) {
        try {
            FileUtils.checkForBadFilePatterns(path);
        }
        catch (Exception ex) {
            this.logger.logDebug(() -> String.format("Bad path requested at readStaticFile: %s.  Exception: %s", path, ex.getMessage()));
            return Response.buildLeanResponse(StatusLine.StatusCode.CODE_400_BAD_REQUEST);
        }
        String mimeType = null;
        try {
            FileUtils.checkFileIsWithinDirectory(path, this.constants.staticFilesDirectory);
        }
        catch (Exception ex) {
            this.logger.logDebug(() -> String.format("Unable to find %s in allowed directories", path));
            return Response.buildLeanResponse(StatusLine.StatusCode.CODE_404_NOT_FOUND);
        }
        try {
            Path staticFilePath = Path.of(this.constants.staticFilesDirectory, new String[0]).resolve(path);
            if (!Files.isRegularFile(staticFilePath, new LinkOption[0])) {
                this.logger.logDebug(() -> String.format("No readable regular file found at %s", path));
                return Response.buildLeanResponse(StatusLine.StatusCode.CODE_404_NOT_FOUND);
            }
            int suffixBeginIndex = path.lastIndexOf(46);
            if (suffixBeginIndex > 0) {
                String suffix = path.substring(suffixBeginIndex + 1);
                mimeType = this.fileSuffixToMime.get(suffix);
            }
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            if (Files.size(staticFilePath) < 100000L) {
                byte[] fileContents = this.fileReader.readFile(staticFilePath.toString());
                return this.createOkResponseForStaticFiles(fileContents, mimeType);
            }
            return this.createOkResponseForLargeStaticFiles(mimeType, staticFilePath, requestHeaders);
        }
        catch (IOException e) {
            this.logger.logAsyncError(() -> String.format("Error while reading file: %s. %s", path, StacktraceUtils.stackTraceToString(e)));
            return Response.buildLeanResponse(StatusLine.StatusCode.CODE_400_BAD_REQUEST);
        }
    }

    private IResponse createOkResponseForStaticFiles(byte[] fileContents, String mimeType) {
        Map<String, String> headers = Map.of("cache-control", "max-age=" + this.constants.staticFileCacheTime, "content-type", mimeType);
        return Response.buildResponse(StatusLine.StatusCode.CODE_200_OK, headers, fileContents);
    }

    private IResponse createOkResponseForLargeStaticFiles(String mimeType, Path filePath, Headers requestHeaders) throws IOException {
        Map<String, String> headers = Map.of("cache-control", "max-age=" + this.constants.staticFileCacheTime, "content-type", mimeType, "Accept-Ranges", "bytes");
        return Response.buildLargeFileResponse(headers, filePath.toString(), requestHeaders);
    }

    private void addDefaultValuesForMimeMap() {
        this.fileSuffixToMime.put("css", "text/css");
        this.fileSuffixToMime.put("js", "application/javascript");
        this.fileSuffixToMime.put("webp", "image/webp");
        this.fileSuffixToMime.put("jpg", "image/jpeg");
        this.fileSuffixToMime.put("jpeg", "image/jpeg");
        this.fileSuffixToMime.put("htm", "text/html");
        this.fileSuffixToMime.put("html", "text/html");
    }

    ThrowingFunction<IRequest, IResponse> findHandlerByPartialMatch(RequestLine sl) {
        String requestedPath = sl.getPathDetails().getIsolatedPath();
        Map.Entry methodPathFunctionEntry = this.registeredPartialPaths.entrySet().stream().filter(x -> requestedPath.startsWith(((MethodPath)x.getKey()).path()) && ((MethodPath)x.getKey()).method().equals((Object)sl.getMethod())).findFirst().orElse(null);
        if (methodPathFunctionEntry != null) {
            return (ThrowingFunction)methodPathFunctionEntry.getValue();
        }
        return null;
    }

    WebFramework(Context context) {
        this(context, null, null);
    }

    WebFramework(Context context, ZonedDateTime overrideForDateTime) {
        this(context, overrideForDateTime, null);
    }

    WebFramework(Context context, ZonedDateTime overrideForDateTime, IFileReader fileReader) {
        this.fs = context.getFullSystem();
        this.logger = context.getLogger();
        this.constants = context.getConstants();
        this.overrideForDateTime = overrideForDateTime;
        this.registeredDynamicPaths = new HashMap<MethodPath, ThrowingFunction<IRequest, IResponse>>();
        this.registeredPartialPaths = new HashMap<MethodPath, ThrowingFunction<IRequest, IResponse>>();
        this.underInvestigation = new UnderInvestigation(this.constants);
        this.inputStreamUtils = new InputStreamUtils(this.constants.maxReadLineSizeBytes);
        this.bodyProcessor = new BodyProcessor(context);
        this.randomErrorCorrelationId = new Random();
        this.emptyRequestLine = RequestLine.EMPTY;
        this.fileReader = fileReader != null ? fileReader : new FileReader(LRUCache.getLruCache(this.constants.maxElementsLruCacheStaticFiles), this.constants.useCacheForStaticFiles, this.logger);
        this.fileSuffixToMime = new HashMap<String, String>();
        this.addDefaultValuesForMimeMap();
        this.readExtraMimeMappings(this.constants.extraMimeMappings);
    }

    void readExtraMimeMappings(List<String> input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        Invariants.mustBeTrue(input.size() % 2 == 0, "input must be even (key + value = 2 items). Your input: " + String.valueOf(input));
        for (int i = 0; i < input.size(); i += 2) {
            String fileSuffix = input.get(i);
            String mime = input.get(i + 1);
            this.logger.logTrace(() -> "Adding mime mapping: " + fileSuffix + " -> " + mime);
            this.fileSuffixToMime.put(fileSuffix, mime);
        }
    }

    public void registerPath(RequestLine.Method method, String pathName, ThrowingFunction<IRequest, IResponse> webHandler) {
        this.registeredDynamicPaths.put(new MethodPath(method, pathName), webHandler);
    }

    public void registerPartialPath(RequestLine.Method method, String pathName, ThrowingFunction<IRequest, IResponse> webHandler) {
        this.registeredPartialPaths.put(new MethodPath(method, pathName), webHandler);
    }

    public void registerPreHandler(ThrowingFunction<PreHandlerInputs, IResponse> preHandler) {
        this.preHandler = preHandler;
    }

    public void registerLastMinuteHandler(ThrowingFunction<LastMinuteHandlerInputs, IResponse> lastMinuteHandler) {
        this.lastMinuteHandler = lastMinuteHandler;
    }

    public void addMimeForSuffix(String suffix, String mimeType) {
        this.fileSuffixToMime.put(suffix, mimeType);
    }

    record ProcessingResult(IRequest clientRequest, IResponse resultingResponse) {
    }

    record MethodPath(RequestLine.Method method, String path) {
    }
}

