/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.reprezen.kaizen.oasparser.OpenApi;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonLoader;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionBaseRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.Resolver;
import com.reprezen.kaizen.oasparser.ovl3.OpenApi3Impl;
import com.reprezen.kaizen.oasparser.val3.ValidationConfigurator;
import com.reprezen.kaizen.oasparser.val3.ovl.OverlayValidationConfigurator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class OpenApiParser {
    private Injector injector;

    public OpenApiParser() {
        this(new OverlayValidationConfigurator());
    }

    public OpenApiParser(ValidationConfigurator validationConfigurator) {
        this.injector = Guice.createInjector((Module[])new Module[]{validationConfigurator});
    }

    public OpenApi<?> parse(String spec, URL resolutionBase) {
        return this.parse(spec, resolutionBase, true);
    }

    public OpenApi<?> parse(String spec, URL resolutionBase, boolean validate) {
        try {
            JsonLoader jsonLoader = new JsonLoader();
            JsonNode tree = jsonLoader.loadString(resolutionBase, spec);
            ResolutionBaseRegistry resolutionBaseRegistry = new ResolutionBaseRegistry(jsonLoader);
            resolutionBaseRegistry.register(resolutionBase.toString(), tree);
            return this.parse(resolutionBase, validate, resolutionBaseRegistry);
        }
        catch (IOException e) {
            throw new SwaggerParserException("Failed to parse spec as JSON or YAML", e);
        }
    }

    public OpenApi<?> parse(File specFile) {
        return this.parse(specFile, true);
    }

    public OpenApi<?> parse(File specFile, boolean validate) {
        try {
            return this.parse(specFile.toURI().toURL(), validate);
        }
        catch (IOException e) {
            throw new SwaggerParserException("Failed to read spec from file", e);
        }
    }

    public OpenApi<?> parse(URI uri) {
        return this.parse(uri, true);
    }

    public OpenApi<?> parse(URI uri, boolean validate) {
        try {
            return this.parse(uri.toURL(), validate);
        }
        catch (MalformedURLException e) {
            throw new SwaggerParserException("Invalid URI for Swagger spec", e);
        }
    }

    public OpenApi<?> parse(URL resolutionBase) {
        return this.parse(resolutionBase, true);
    }

    public OpenApi<?> parse(URL resolutionBase, boolean validate) {
        return this.parse(resolutionBase, validate, new ResolutionBaseRegistry(new JsonLoader()));
    }

    protected OpenApi<?> parse(URL resolutionBase, boolean validate, ResolutionBaseRegistry resolutionBaseRegistry) {
        ReferenceRegistry referenceRegistry = new ReferenceRegistry();
        new Resolver(referenceRegistry, resolutionBaseRegistry).preresolve(resolutionBase);
        JsonNode tree = resolutionBaseRegistry.get(resolutionBase.toString()).getJson();
        if (this.isVersion3(tree)) {
            OpenApi3Impl model = new OpenApi3Impl(tree, null, referenceRegistry);
            this.injector.injectMembers((Object)model);
            if (validate) {
                model.validate();
            }
            return model;
        }
        throw new SwaggerParserException("Could not determine OpenApi version - missing or invalid 'openapi' or 'swagger' property");
    }

    protected boolean isVersion3(JsonNode tree) {
        JsonNode versionNode = tree.path("openapi");
        return versionNode.isTextual() && versionNode.asText().startsWith("3.");
    }

    public static class SwaggerParserException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SwaggerParserException() {
        }

        public SwaggerParserException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public SwaggerParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public SwaggerParserException(String message) {
            super(message);
        }

        public SwaggerParserException(Throwable cause) {
            super(cause);
        }
    }
}

