/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ScalarOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;

public class BooleanOverlay
extends ScalarOverlay<Boolean> {
    public static OverlayFactory<Boolean, BooleanOverlay> factory = new OverlayFactory<Boolean, BooleanOverlay>(){

        @Override
        protected Class<BooleanOverlay> getOverlayClass() {
            return BooleanOverlay.class;
        }

        @Override
        public BooleanOverlay _create(Boolean value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new BooleanOverlay(value, parent, refReg);
        }

        @Override
        public BooleanOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new BooleanOverlay(json, parent, refReg);
        }
    };

    private BooleanOverlay(Boolean value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    private BooleanOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    @Override
    public Boolean fromJson(JsonNode json) {
        return json.isBoolean() ? Boolean.valueOf(json.booleanValue()) : null;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        return this.value != null ? BooleanOverlay.jsonBoolean((Boolean)this.value) : BooleanOverlay.jsonMissing();
    }
}

