/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import java.util.Collection;

public class ChildListOverlay<V, OV extends JsonOverlay<V>>
extends ChildOverlay<Collection<V>, ListOverlay<V, OV>> {
    private ListOverlay<V, OV> listOverlay;

    public ChildListOverlay(String path, JsonNode json, JsonOverlay<?> parent, OverlayFactory<Collection<V>, ListOverlay<V, OV>> factory, ReferenceRegistry refReg) {
        super(path, json, parent, factory, refReg);
        this.setListOverlay();
    }

    public ChildListOverlay(String path, Collection<V> value, JsonOverlay<?> parent, OverlayFactory<Collection<V>, ListOverlay<V, OV>> factory, ReferenceRegistry refReg) {
        super(path, value, parent, factory, refReg);
        this.setListOverlay();
    }

    private void setListOverlay() {
        ListOverlay castOverlay;
        this.listOverlay = castOverlay = (ListOverlay)this.overlay;
    }

    @Override
    protected boolean matchesPath(JsonPointer path) {
        if (super.matchesPath(path)) {
            int index = super.tailPath(path).getMatchingIndex();
            return index >= 0;
        }
        return false;
    }

    public V get(int index) {
        return this.listOverlay.get(index);
    }

    public void set(int index, V value) {
        this.listOverlay.set(index, value);
    }

    public void add(V value) {
        this.listOverlay.add(value);
    }

    public void insert(int index, V value) {
        this.listOverlay.insert(index, value);
    }

    public void remove(int index) {
        this.listOverlay.remove(index);
    }

    public int size() {
        return this.listOverlay.size();
    }

    public ChildOverlay<V, OV> getChild(int index) {
        ChildOverlay child = (ChildOverlay)this.listOverlay.getOverlay(index);
        return child;
    }
}

