/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonPath;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;

public class ChildOverlay<V, OV extends JsonOverlay<V>>
implements IJsonOverlay<V> {
    private JsonPath path;
    protected JsonOverlay<V> overlay;
    private JsonOverlay<?> parent;
    private Reference reference = null;
    protected OverlayFactory<V, OV> factory;
    private static final SerializationOptions emptyOptions = new SerializationOptions(new SerializationOptions.Option[0]);

    public ChildOverlay(String path, V value, JsonOverlay<?> parent, OverlayFactory<V, OV> factory, ReferenceRegistry refReg) {
        this.path = new JsonPath(path);
        this.parent = parent;
        this.factory = factory;
        this.overlay = factory.create(value, parent, refReg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChildOverlay(String path, JsonNode json, JsonOverlay<?> parent, OverlayFactory<V, OV> factory, ReferenceRegistry refReg) {
        this.path = new JsonPath(path);
        this.parent = parent;
        this.factory = factory;
        if (this.isReferenceNode(json)) {
            this.reference = refReg.getRef(json);
            JsonNode resolved = this.reference.resolve();
            if (this.reference.isValid()) {
                if (refReg.hasOverlay(resolved)) {
                    JsonOverlay<?> overlay = refReg.getOverlay(resolved);
                    if (!factory.isCompatible(overlay)) throw new IllegalStateException("Referenced object is not compatible with referencing site");
                    JsonOverlay<?> castOverlay = overlay;
                    this.overlay = castOverlay;
                    return;
                } else {
                    this.overlay = factory.create(resolved, (JsonOverlay<?>)null, refReg);
                    refReg.setOverlay(resolved, this.overlay);
                }
                return;
            } else {
                this.overlay = null;
            }
            return;
        } else {
            this.overlay = factory.create(json, parent, this.isPartial(), refReg);
        }
    }

    protected boolean isPartial() {
        return false;
    }

    protected boolean matchesPath(JsonPointer path) {
        return this.path.matchesPath(path);
    }

    protected JsonPointer tailPath(JsonPointer path) {
        return this.path.tailPath(path);
    }

    private boolean isReferenceNode(JsonNode node) {
        return node.isObject() && node.has("$ref");
    }

    @Override
    public boolean isPresent() {
        return this.overlay.isPresent();
    }

    @Override
    public V get() {
        return this.overlay.get();
    }

    @Override
    public V get(boolean complete) {
        return this.overlay.get(complete);
    }

    @Override
    public IJsonOverlay<?> find(JsonPointer path) {
        return this.overlay.find(path);
    }

    @Override
    public IJsonOverlay<?> find(String path) {
        return this.overlay.find(path);
    }

    @Override
    public void set(V value) {
        this.overlay.set(value);
    }

    @Override
    public IJsonOverlay<?> getParent() {
        return this.parent;
    }

    @Override
    public String getPathInParent() {
        return this.overlay.getPathInParent();
    }

    @Override
    public IJsonOverlay<?> getRoot() {
        return this.parent != null ? this.parent.getParent() : this.overlay.getRoot();
    }

    @Override
    public JsonNode toJson() {
        return this.toJson(emptyOptions);
    }

    @Override
    public JsonNode toJson(SerializationOptions.Option ... options) {
        return this.toJson(new SerializationOptions(options));
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        if (this.isReference() && (!options.isFollowRefs() || this.getReference().isInvalid())) {
            ObjectNode obj = JsonOverlay.jsonObject();
            obj.put("$ref", this.reference.getRefString());
            return obj;
        }
        return this.overlay.toJson(options);
    }

    @Override
    public boolean isElaborated() {
        return this.overlay.isElaborated();
    }

    public JsonPath getPath() {
        return this.path;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public Reference getReference() {
        return this.reference;
    }

    public JsonOverlay<V> getOverlay() {
        return this.overlay;
    }

    public String toString() {
        String refString = this.reference != null ? String.format("<%s>", this.reference.getRefString()) : "";
        return String.format("Child@%s%s: %s", this.path, refString, this.overlay);
    }
}

