/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ScalarOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;

public class IntegerOverlay
extends ScalarOverlay<Integer> {
    public static OverlayFactory<Integer, IntegerOverlay> factory = new OverlayFactory<Integer, IntegerOverlay>(){

        @Override
        protected Class<IntegerOverlay> getOverlayClass() {
            return IntegerOverlay.class;
        }

        @Override
        public IntegerOverlay _create(Integer value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new IntegerOverlay(value, parent, refReg);
        }

        @Override
        public IntegerOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new IntegerOverlay(json, parent, refReg);
        }
    };

    private IntegerOverlay(Integer value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    private IntegerOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    @Override
    public Integer fromJson(JsonNode json) {
        return json.isInt() ? Integer.valueOf(json.intValue()) : null;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        return this.value != null ? IntegerOverlay.jsonScalar((Integer)this.value) : IntegerOverlay.jsonMissing();
    }
}

