/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class JsonLoader {
    private static ObjectMapper jsonMapper = new ObjectMapper();
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private Yaml yaml = new Yaml();
    private Map<String, JsonNode> cache = Maps.newHashMap();

    public JsonNode load(URL url) throws IOException {
        String urlString = url.toString();
        if (this.cache.containsKey(urlString)) {
            return this.cache.get(urlString);
        }
        String json = IOUtils.toString((InputStream)url.openStream(), (Charset)Charsets.UTF_8);
        return this.loadString(url, json);
    }

    public JsonNode loadString(URL url, String json) throws IOException, JsonProcessingException {
        JsonNode tree;
        if (json.trim().startsWith("{")) {
            tree = jsonMapper.readTree(json);
        } else {
            Object parsedYaml = this.yaml.load(json);
            tree = (JsonNode)yamlMapper.convertValue(parsedYaml, JsonNode.class);
        }
        if (url != null) {
            this.cache.put(url.toString(), tree);
        }
        return tree;
    }
}

