/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class JsonOverlay<V>
implements IJsonOverlay<V> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected V value = null;
    protected JsonOverlay<?> parent;
    protected JsonNode json = null;
    protected ReferenceRegistry refReg;
    private String pathInParent = null;
    private static final SerializationOptions emptyOptions = new SerializationOptions(new SerializationOptions.Option[0]);

    public JsonOverlay(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        this.value = value;
        this.parent = parent;
        this.refReg = refReg;
    }

    public JsonOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        this.json = json;
        this.value = this.fromJson(json);
        this.parent = parent;
        this.refReg = refReg;
    }

    @Override
    public V get() {
        return this.get(true);
    }

    @Override
    public abstract V get(boolean var1);

    @Override
    public boolean isPresent() {
        return this.value != null && !this.json.isMissingNode();
    }

    @Override
    public boolean isElaborated() {
        return true;
    }

    @Override
    public IJsonOverlay<?> find(JsonPointer path) {
        return path.matches() ? this : this._find(path);
    }

    protected abstract IJsonOverlay<?> _find(JsonPointer var1);

    @Override
    public IJsonOverlay<?> find(String path) {
        return this.find(JsonPointer.compile((String)path));
    }

    @Override
    public void set(V value) {
        this.set(value, true);
    }

    protected void set(V value, boolean invalidate) {
        this.value = value;
    }

    @Override
    public JsonOverlay<?> getParent() {
        return this.parent;
    }

    protected void setParent(JsonOverlay<?> parent) {
        this.parent = parent;
    }

    protected void setPathInParent(String pathInParent) {
        this.pathInParent = pathInParent;
    }

    @Override
    public String getPathInParent() {
        return this.pathInParent;
    }

    @Override
    public JsonOverlay<?> getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    protected abstract V fromJson(JsonNode var1);

    @Override
    public JsonNode toJson() {
        return this.toJson(emptyOptions);
    }

    @Override
    public JsonNode toJson(SerializationOptions.Option ... options) {
        return this.toJson(new SerializationOptions(options));
    }

    @Override
    public abstract JsonNode toJson(SerializationOptions var1);

    protected static ObjectNode jsonObject() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected static ArrayNode jsonArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    protected static TextNode jsonScalar(String s) {
        return JsonNodeFactory.instance.textNode(s);
    }

    protected static ValueNode jsonScalar(int n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(long n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(short n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(byte n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(double n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(float n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(BigInteger n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(BigDecimal n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonBoolean(boolean b) {
        return JsonNodeFactory.instance.booleanNode(b);
    }

    protected static MissingNode jsonMissing() {
        return MissingNode.getInstance();
    }

    protected static final <T> Iterable<T> iterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public String toString() {
        return this.toJson().toString();
    }
}

