/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class JsonPointerTrie<T> {
    private Map<Pattern, T> patternMap = Maps.newHashMap();
    private Map<String, JsonPointerTrie<T>> children = Maps.newHashMap();

    public void add(JsonPointer path, Pattern pattern, T value) {
        if (path.matches()) {
            this.patternMap.put(pattern, value);
        } else {
            String childKey = path.getMatchingProperty();
            if (!this.children.containsKey(childKey)) {
                this.children.put(childKey, new JsonPointerTrie<T>());
            }
            this.children.get(childKey).add(path.tail(), pattern, value);
        }
    }

    public Pair<T, JsonPointer> find(JsonPointer path) {
        if (path.matches()) {
            return Pair.of(this.patternMap.get(null), (Object)path);
        }
        String key = path.getMatchingProperty();
        if (this.children.containsKey(key)) {
            return this.children.get(key).find(path.tail());
        }
        for (Pattern pat : this.patternMap.keySet()) {
            if (pat == null || !pat.matcher(key).matches()) continue;
            return Pair.of(this.patternMap.get(pat), (Object)path);
        }
        return Pair.of(this.patternMap.get(null), (Object)path);
    }
}

