/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.util.Collection;
import java.util.List;

public class ListOverlay<V, OV extends JsonOverlay<V>>
extends JsonOverlay<Collection<V>> {
    private OverlayFactory<V, OV> itemFactory;
    private List<IJsonOverlay<V>> overlays = Lists.newLinkedList();

    public ListOverlay(Collection<V> value, JsonOverlay<?> parent, OverlayFactory<V, OV> itemFactory, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.itemFactory = itemFactory;
        this.fillWithValues();
    }

    public ListOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V, OV> itemFactory, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.itemFactory = itemFactory;
        this.fillWithJson();
    }

    private void fillWithValues() {
        this.overlays.clear();
        if (this.value != null) {
            for (Object item : (Collection)this.value) {
                this.overlays.add(new ChildOverlay(null, item, this, this.itemFactory, this.refReg));
            }
        }
    }

    private void fillWithJson() {
        ((Collection)this.value).clear();
        this.overlays.clear();
        for (JsonNode itemJson : ListOverlay.iterable(this.json.elements())) {
            ChildOverlay<V, OV> overlay = new ChildOverlay<V, OV>(null, itemJson, (JsonOverlay<?>)this, this.itemFactory, this.refReg);
            this.overlays.add(overlay);
            ((Collection)this.value).add(overlay.get(false));
        }
    }

    @Override
    public Collection<V> get(boolean elaborate) {
        return (Collection)this.value;
    }

    @Override
    protected Collection<V> fromJson(JsonNode json) {
        return Lists.newArrayList();
    }

    @Override
    public IJsonOverlay<?> _find(JsonPointer path) {
        int index = path.getMatchingIndex();
        return this.overlays.size() > index ? this.overlays.get(index).find(path.tail()) : null;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        ArrayNode array = ListOverlay.jsonArray();
        for (IJsonOverlay<V> overlay : this.overlays) {
            array.add(overlay.toJson(options.plus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return array.size() > 0 || options.isKeepThisEmpty() ? array : ListOverlay.jsonMissing();
    }

    public V get(int index) {
        IJsonOverlay<V> overlay = this.overlays.get(index);
        return overlay != null ? (V)overlay.get() : null;
    }

    public IJsonOverlay<V> getOverlay(int index) {
        return this.overlays.get(index);
    }

    public void set(int index, V value) {
        this.overlays.set(index, (IJsonOverlay<V>)this.itemFactory.create(value, this, this.refReg));
    }

    public void add(V value) {
        this.overlays.add((IJsonOverlay<V>)this.itemFactory.create(value, this, this.refReg));
    }

    public void insert(int index, V value) {
        this.overlays.add(index, (IJsonOverlay<V>)this.itemFactory.create(value, this, this.refReg));
    }

    public void remove(int index) {
        this.overlays.remove(index);
    }

    public int size() {
        return this.overlays.size();
    }

    public boolean isReference(int index) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(index);
        return childOverlay.isReference();
    }

    public Reference getReference(int index) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(index);
        return childOverlay.getReference();
    }

    public static <V, OV extends JsonOverlay<V>> OverlayFactory<Collection<V>, ListOverlay<V, OV>> getFactory(OverlayFactory<V, OV> itemFactory) {
        return new ListOverlayFactory<V, OV>(itemFactory);
    }

    private static class ListOverlayFactory<V, OV extends JsonOverlay<V>>
    extends OverlayFactory<Collection<V>, ListOverlay<V, OV>> {
        private OverlayFactory<V, OV> itemFactory;

        public ListOverlayFactory(OverlayFactory<V, OV> itemFactory) {
            this.itemFactory = itemFactory;
        }

        @Override
        protected Class<? super ListOverlay<V, OV>> getOverlayClass() {
            return ListOverlay.class;
        }

        @Override
        public ListOverlay<V, OV> _create(Collection<V> value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new ListOverlay<V, OV>(value, parent, this.itemFactory, refReg);
        }

        @Override
        public ListOverlay<V, OV> _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new ListOverlay<V, OV>(json, parent, this.itemFactory, refReg);
        }
    }
}

