/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.util.Map;
import java.util.regex.Pattern;

public class MapOverlay<V, OV extends JsonOverlay<V>>
extends JsonOverlay<Map<String, V>> {
    private Map<String, IJsonOverlay<V>> overlays = Maps.newLinkedHashMap();
    private OverlayFactory<V, OV> valueFactory;
    private Pattern keyPattern;

    public MapOverlay(Map<String, V> value, JsonOverlay<?> parent, OverlayFactory<V, OV> valueFactory, Pattern keyPattern, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.valueFactory = valueFactory;
        this.keyPattern = keyPattern;
        this.fillWithValues();
    }

    public MapOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V, OV> valueFactory, Pattern keyPattern, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.valueFactory = valueFactory;
        this.keyPattern = keyPattern;
        this.fillWithJson();
    }

    private void fillWithValues() {
        this.overlays.clear();
        if (this.value != null) {
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                this.overlays.put((String)entry.getKey(), new ChildOverlay((String)entry.getKey(), entry.getValue(), this, this.valueFactory, this.refReg));
            }
        }
    }

    private void fillWithJson() {
        ((Map)this.value).clear();
        this.overlays.clear();
        for (Map.Entry field : MapOverlay.iterable(this.json.fields())) {
            String key = (String)field.getKey();
            if (this.keyPattern != null && !this.keyPattern.matcher(key).matches()) continue;
            ChildOverlay<V, OV> overlay = new ChildOverlay<V, OV>(key, this.json.get(key), (JsonOverlay<?>)this, this.valueFactory, this.refReg);
            overlay.getOverlay().setPathInParent(key);
            this.overlays.put(key, overlay);
            ((Map)this.value).put(key, overlay.get(false));
        }
    }

    @Override
    public Map<String, V> get(boolean elaborate) {
        return (Map)this.value;
    }

    @Override
    public IJsonOverlay<?> _find(JsonPointer path) {
        String key = path.getMatchingProperty();
        return this.overlays.containsKey(key) ? this.overlays.get(key).find(path.tail()) : null;
    }

    @Override
    protected Map<String, V> fromJson(JsonNode json) {
        return Maps.newHashMap();
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        ObjectNode obj = MapOverlay.jsonObject();
        for (Map.Entry<String, IJsonOverlay<V>> entry : this.overlays.entrySet()) {
            obj.set(entry.getKey(), entry.getValue().toJson(options.plus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return obj.size() > 0 || options.isKeepThisEmpty() ? obj : MapOverlay.jsonMissing();
    }

    public boolean containsKey(String name) {
        return this.overlays.containsKey(name);
    }

    public V get(String name) {
        IJsonOverlay<V> overlay = this.overlays.get(name);
        return overlay != null ? (V)overlay.get() : null;
    }

    protected IJsonOverlay<V> getOverlay(String name) {
        return this.overlays.get(name);
    }

    public void set(String name, V value) {
        this.overlays.put(name, (IJsonOverlay<OV>)this.valueFactory.create(value, this, this.refReg));
    }

    public void remove(String name) {
        this.overlays.remove(name);
    }

    public int size() {
        return this.overlays.size();
    }

    public Pattern getKeyPattern() {
        return this.keyPattern;
    }

    public boolean isReference(String key) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(key);
        return childOverlay.isReference();
    }

    public Reference getReference(String key) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(key);
        return childOverlay.getReference();
    }

    public static <V, OV extends JsonOverlay<V>> OverlayFactory<Map<String, V>, MapOverlay<V, OV>> getFactory(OverlayFactory<V, OV> valueFactory, String keyPattern) {
        return new MapOverlayFactory<V, OV>(valueFactory, MapOverlay.getWholeMatchPattern(keyPattern));
    }

    private static Pattern getWholeMatchPattern(String pat) {
        return pat != null ? Pattern.compile("^" + pat + "$") : null;
    }

    protected static class MapOverlayFactory<V, OV extends JsonOverlay<V>>
    extends OverlayFactory<Map<String, V>, MapOverlay<V, OV>> {
        private OverlayFactory<V, OV> valueFactory;
        private Pattern keyPattern;

        public MapOverlayFactory(OverlayFactory<V, OV> valueFactory, Pattern keyPattern) {
            this.valueFactory = valueFactory;
            this.keyPattern = keyPattern;
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }

        @Override
        protected Class<? super MapOverlay<V, OV>> getOverlayClass() {
            return MapOverlay.class;
        }

        @Override
        public MapOverlay<V, OV> _create(Map<String, V> value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new MapOverlay<V, OV>(value, parent, this.valueFactory, this.keyPattern, refReg);
        }

        @Override
        public MapOverlay<V, OV> _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new MapOverlay<V, OV>(json, parent, this.valueFactory, this.keyPattern, refReg);
        }
    }
}

