/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ScalarOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class NumberOverlay
extends ScalarOverlay<Number> {
    public static OverlayFactory<Number, NumberOverlay> factory = new OverlayFactory<Number, NumberOverlay>(){

        @Override
        protected Class<NumberOverlay> getOverlayClass() {
            return NumberOverlay.class;
        }

        @Override
        public NumberOverlay _create(Number value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new NumberOverlay(value, parent, refReg);
        }

        @Override
        public NumberOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new NumberOverlay(json, parent, refReg);
        }
    };

    private NumberOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    private NumberOverlay(Number value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    @Override
    public Number fromJson(JsonNode json) {
        if (json.isBigDecimal()) {
            return json.decimalValue();
        }
        if (json.isBigInteger()) {
            return json.bigIntegerValue();
        }
        if (json.isDouble()) {
            return json.doubleValue();
        }
        if (json.isFloat()) {
            return Float.valueOf(json.floatValue());
        }
        if (json.isInt()) {
            return json.intValue();
        }
        if (json.isLong()) {
            return json.longValue();
        }
        if (json.isShort()) {
            return json.shortValue();
        }
        return null;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        if (this.value == null) {
            return NumberOverlay.jsonMissing();
        }
        NumberType type = NumberType.of((Number)this.value);
        if (type == null) {
            throw new IllegalArgumentException("Numeric class " + ((Number)this.value).getClass().getName() + " is not representable as a JsonNode");
        }
        switch (type) {
            case BigDecimal: {
                return NumberOverlay.jsonScalar((BigDecimal)this.value);
            }
            case BigInteger: {
                return NumberOverlay.jsonScalar((BigInteger)this.value);
            }
            case Byte: {
                return NumberOverlay.jsonScalar((Byte)this.value);
            }
            case Double: {
                return NumberOverlay.jsonScalar((Double)this.value);
            }
            case Float: {
                return NumberOverlay.jsonScalar(((Float)this.value).floatValue());
            }
            case Integer: {
                return NumberOverlay.jsonScalar((Integer)this.value);
            }
            case Long: {
                return NumberOverlay.jsonScalar((Long)this.value);
            }
            case Short: {
                return NumberOverlay.jsonScalar((Short)this.value);
            }
        }
        return NumberOverlay.jsonMissing();
    }

    private static enum NumberType {
        BigDecimal(BigDecimal.class),
        BigInteger(BigInteger.class),
        Byte(Byte.class),
        Double(Double.class),
        Float(Float.class),
        Integer(Integer.class),
        Long(Long.class),
        Short(Short.class);

        private Class<? extends Number> cls;
        private static Map<Class<? extends Number>, NumberType> typeMap;

        private NumberType(Class<? extends Number> cls) {
            this.cls = cls;
        }

        private static <T extends Number> NumberType of(T obj) {
            if (typeMap == null) {
                NumberType.buildTypeMap();
            }
            return typeMap.get(obj.getClass());
        }

        private static void buildTypeMap() {
            typeMap = Maps.newHashMap();
            for (NumberType type : NumberType.values()) {
                typeMap.put(type.cls, type);
            }
        }

        static {
            typeMap = null;
        }
    }
}

